//
//  SRLibraryPreviewController.swift
//  CTFit
//
//  Created by Mac on 2020/11/19.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import UIKit
import Photos

class SRLibraryPreviewController: BaseViewController, CustomView {
    
    typealias ViewClass = SRLibraryPreviewView
    
    required init(_ manager: SRLibraryMediaManager, _ index: Int) {
        self.manager = manager
        self.index = index
        super.init()
        navigationItem.title = SRString.ImagePicker.preview.locastr
    }
    
    override func loadView() {
        super.loadView()
        view = ViewClass()
    }
    
    override func initNavigationBar() {
        super.initNavigationBar()
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        view.backgroundColor = Colors.black
        customView.loadWith(manager, index)
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
    }
    
    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated)
    }
    
    ///:  - Field
    private var manager: SRLibraryMediaManager
    var index: Int

}

extension SRLibraryPreviewController {
    @discardableResult
    static func enter(_ manager: SRLibraryMediaManager, _ index: Int) -> SRLibraryPreviewController? {
        guard let vc = Helper.currentVc else { return nil }
        let previewVc = SRLibraryPreviewController(manager, index)
        vc.navigationController?.pushViewController(previewVc, animated: true)
        return previewVc
    }
}
