//
//  SRPreviewAreaView.swift
//  CTFit
//
//  Created by Mac on 2020/11/16.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import Foundation
import UIKit
import AVFoundation
import Photos

/// The container for asset (video or image). It containts the SRGridView and SRAssetZoomableView.
class SRLibraryPreviewView: UIView {
    
    @available(*, unavailable)
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    init() {
        super.init(frame: .zero)
        clipsToBounds = true
        setupSubviews()
        spinner.startAnimating()
        curtain.backgroundColor = UIColor.gray.withAlphaComponent(0.7)
        curtain.alpha = 0
    }
    
    ///: - View customer
    
    public lazy var zoomableView: SRPreviewZoomableView = {
        let view = SRPreviewZoomableView()
        view.myDelegate = self
        return view
    } ()
        
    public lazy var spinnerView: UIView = {
        let view = UIView()
        view.addSubview(spinner)
        view.isUserInteractionEnabled = false
        spinner.snp.makeConstraints { (make) in
            make.center.equalToSuperview()
        }
        return view
    } ()
    
    private lazy var spinner: UIActivityIndicatorView = {
        let view = UIActivityIndicatorView(style: .whiteLarge)
        view.tintColor = .gray
        return view
    } ()
    
    public lazy var curtain: UIView = {
        UIView()
    } ()
        
    private func setupSubviews() {
        let items = [zoomableView, spinnerView, curtain]
        items.forEach { view in
            view.translatesAutoresizingMaskIntoConstraints = false
            addSubview(view)
        }
        
        zoomableView.snp.makeConstraints { (make) in
            make.edges.equalToSuperview().inset(UIEdgeInsets(top: 0, left: 0, bottom: 0, right: 0))
        }
        
        spinnerView.snp.makeConstraints { (make) in
            make.edges.equalToSuperview().inset(UIEdgeInsets(top: 0, left: 0, bottom: 0, right: 0))
        }
        
        curtain.snp.makeConstraints { (make) in
            make.edges.equalToSuperview().inset(UIEdgeInsets(top: 0, left: 0, bottom: 0, right: 0))
        }
    }
    
    func fitImage() {
        zoomableView.fitImage(false)
    }
    
    func loadWith(_ mediaManager: SRLibraryMediaManager, _ index: Int) {
        guard let fetchResult = mediaManager.fetchResult, index < fetchResult.count else { return }
        let asset = fetchResult[index]
        //DispatchQueue.global(qos: .userInitiated).async {
            switch asset.mediaType {
            case .image: 
                self.zoomableView.setImage(asset, mediaManager: mediaManager, storedCropPosition: nil) {_ in
                    self.spinner.stopAnimating()
                } updateCropInfo: {

                }
            case .video:
                self.zoomableView.setVideo(asset, mediaManager: mediaManager, storedCropPosition: nil) {
                    self.spinner.stopAnimating()
                } updateCropInfo: {
                    
                }

            case .audio, .unknown:
                ()
            @unknown default:
                fatalError()
            }
       // }
    }
}

// MARK: - ZoomableViewDelegate

extension SRLibraryPreviewView: SRPreviewZoomableViewDelegate {
    
    public func srAssetZoomableViewDidLayoutSubviews(_ zoomableView: SRPreviewZoomableView) {
        // Update play imageView position - bringing the playImageView from the videoView to assetViewContainer,
        // but the controll for appearing it still in videoView.
        if zoomableView.videoView.playImageView.isDescendant(of: self) == false {
            self.addSubview(zoomableView.videoView.playImageView)
            zoomableView.videoView.playImageView.snp.makeConstraints { (make) in
                make.center.equalToSuperview()
            }
        }
    }
    
    public func srAssetZoomableViewScrollViewDidZoom() { }
    
    public func srAssetZoomableViewScrollViewDidEndZooming() { }
}

// MARK: - Gesture recognizer Delegate
extension SRLibraryPreviewView: UIGestureRecognizerDelegate {
    public func gestureRecognizer(_ gestureRecognizer: UIGestureRecognizer, shouldRecognizeSimultaneouslyWith
        otherGestureRecognizer: UIGestureRecognizer) -> Bool {
        return true
    }
    
    public func gestureRecognizer(_ gestureRecognizer: UIGestureRecognizer, shouldReceive touch: UITouch) -> Bool {
        return !(touch.view is UIButton)
    }

}
