//
//  PickerOptionsUitls.swift
//  CTFit
//
//  Created by Mac on 2020/6/1.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit
import Foundation

extension BDVibrateType {
    var text: String {
        switch self {
        case .none: return SRString.Vibrate.vibrate_non.locastr
        case .staccato: return SRString.Vibrate.staccato.locastr
        case .wave: return SRString.Vibrate.wave.locastr
        case .heartbeat: return SRString.Vibrate.heartbeat.locastr
        case .radiate: return SRString.Vibrate.radiate.locastr
        case .lighthouse: return SRString.Vibrate.lighthouse.locastr
        case .symphony: return SRString.Vibrate.symphony.locastr
        case .quick: return SRString.Vibrate.quick.locastr
        }
    }
    static let textCollection: [String] = BDVibrateType.collection.map { (type) -> String in type.text }
    static func parse(_ text: String) -> BDVibrateType{
        var type: BDVibrateType = .none
        for e in collection { if e.text==text { type = e; break } }
        return type
    }
}

enum PlickerOptionType {
    /// 用户
    case age, gender, height, weight, handStrong
    case strideWalk, strideRun, goalSteps, goalCalories, goalDistance
    /// 时间
    case timeStart, timeEnd
    /// 振动
    case bell, bellCount
    /// 提醒时间间隔
    case interval
    /// 运动心率警报
    case highestHeartRate, lowestHeartRate
}

final class PickerOptionsUitls {
    
    static func components(_ type: PlickerOptionType, _ system: BDSystemType = .metric) -> [[String]] {
        if type == .age { return age() }
        if type == .gender { return gender() }
        if type == .height { return height(system) }
        if type == .weight { return weight(system) }
        if type == .strideWalk { return strideWalk(system) }
        if type == .strideRun { return strideRun(system) }
        if type == .goalSteps { return goalSteps() }
        if type == .goalCalories { return goalCalories() }
        if type == .goalDistance { return goalDistance(system) }
        if type == .handStrong { return handStrong() }
        
        if type == .timeStart { return timeStart() }
        if type == .timeEnd { return timeEnd() }

        if type == .bell { return bell() }
        if type == .bellCount { return bellCount() }
        if type == .interval { return interval() }
        if type == .highestHeartRate { return highestHeartRate() }
        if type == .lowestHeartRate { return lowestHeartRate() }
        return []
    }
    
    
    // MARK：- 用户
    private static let genderOptions = BDGenderType.collection.map{ $0.text }
    private static let handsOptions = BDHandType.collection.map{ $0.text }
        
    private static func gender() -> [[String]] { return [genderOptions] }
    
    private static func age() -> [[String]] {
        var component = [String]()
        for idx in 5...140 { component.append("\(idx)") }
        return [component]
    }
    
    private static func height(_ type: BDSystemType) -> [[String]] {
        if type == .metric {
            var component = [String]()
            for idx in 90...240 { component.append("\(idx)") }
            return [component]
        } else {
            var component1 = [String]()
            var component2 = [String]()
            for idx in BandCalculator.imperial(cm: 90).foot...BandCalculator.imperial(cm: 240).foot { component1.append("\(idx)") }
            for idx in 0...11 { component2.append("\(idx)") }
            return [component1, component2]
        }
    }
    
    private static func weight(_ type: BDSystemType) -> [[String]] {
        var component = [String]()
        if type == .metric {
            for idx in 40...180 { component.append("\(idx)") }
        } else {
            for idx in lround(BandCalculator.lb(kg: 40))...lround(BandCalculator.lb(kg: 180)) { component.append("\(idx)") }
        }
        return [component]
    }
    
    private static func strideWalk(_ type: BDSystemType) -> [[String]] {
        if type == .metric {
            var component = [String]()
            for idx in 30...150 { component.append("\(idx)") }
            return [component]
        } else {
            var component1 = [String]()
            var component2 = [String]()
            for idx in BandCalculator.imperial(cm: 30).foot...BandCalculator.imperial(cm: 150).foot { component1.append("\(idx)") }
            for idx in 0...11 { component2.append("\(idx)") }
            return [component1, component2]
        }
    }
    
    private static func strideRun(_ type: BDSystemType) -> [[String]] {
        if type == .metric {
            var component = [String]()
            for idx in 30...150 { component.append("\(idx)") }
            return [component]
        } else {
            var component1 = [String]()
            var component2 = [String]()
            for idx in BandCalculator.imperial(cm: 30).foot...BandCalculator.imperial(cm: 150).foot { component1.append("\(idx)") }
            for idx in 0...11 { component2.append("\(idx)") }
            return [component1, component2]
        }
    }
    
    private static func goalSteps() -> [[String]] {
        var component = [String]()
        for idx in 3...30 { component.append("\(idx*1000)") }
        return [component]
    }
    
    private static func goalCalories() -> [[String]] {
        var component = [String]()
        for idx in 1...10 { component.append("\(idx*100)") }
        return [component]
    }
    
    private static func goalDistance(_ type: BDSystemType) -> [[String]] {
        var component = [String]()
        if type == .metric {
            for idx in 1...25 { component.append("\(idx)") }
        } else {
            for idx in lround(BandCalculator.mile(km: 1))...lround(BandCalculator.mile(km: 25)) { component.append("\(idx)") }
        }
        return [component]
    }
    
    private static func handStrong() -> [[String]] { return [handsOptions] }
    
    
    // MARK: - 时间
    private static let hourOptions: [String] = {
        var component = [String]()
        for idx in 0...23 { component.append("\(idx)") }
        return component
    } ()
    
    private static func timeComponents(_ type: TimeItemType = .start) -> [[String]]  {
        if type == .start { return [hourOptions, ["0"]] }
        return [hourOptions, ["59"]]
    } 
    
    private static func timeStart() -> [[String]] { timeComponents() }
    private static func timeEnd() -> [[String]] { timeComponents(.end) }

    
    // MARK: - 振动
    static let bellOptions: [String] = BDVibrateType.textCollection

    private static func bell() -> [[String]] {
        return [bellOptions]
    }
    
    private static func bellCount() -> [[String]] {
        var component = [String]()
        for idx in 0...31 { component.append("\(idx)") }
        return [component]
    }
    
    // MARK: - 提醒时间间隔
    static let intervalOptions: [String] = ["30", "60", "120", "180"]

    private static func interval() -> [[String]] {
        return [intervalOptions]
    }

    // MARK: - 运动心率警报
    private static func highestHeartRate() -> [[String]] {
        var component = [String]()
        for idx in 100...200 { component.append("\(idx)") }
        return [component]
    }
    private static func lowestHeartRate() -> [[String]] {
        var component = [String]()
        for idx in 40...100 { component.append("\(idx)") }
        return [component]
    }
}
