//
//  SliderCollectionCell.swift
//  CTFit
//
//  Created by Mac on 2020/5/27.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit

class SliderCollectionCell: UICollectionViewCell {
    
    var text: String?
    
    lazy var label: UILabel = {
        let _label = UILabel(style: Stylesheet.Label.naviTitle)
        return _label
    }()
    
    @available(*, unavailable)
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        initSubviews()
    }
        
    private func initSubviews() {
        // contentView.backgroundColor = .gray
        contentView.addSubview(label)
        label.snp.makeConstraints { (make) in
            make.edges.equalTo(self.contentView).inset(UIEdgeInsets(top: 2, left: 0, bottom: 2, right: 0))
        }
    }

    
}
