import UIKit

enum Stylesheet {

    enum Label {
        
        static let naviTitle = Style<UILabel> {
            $0.font = .mediumCustomFont(ofSize: 18)
            $0.numberOfLines = 0
            $0.textColor = Colors.NavigationBar.foreground
            $0.textAlignment = .center
        }
        
        static let text = Style<UILabel> {
            $0.font = .customFont(ofSize: 16)
            $0.numberOfLines = 0
            $0.textColor = Colors.Base.foreground
            $0.textAlignment = .center
        }

        static let title = Style<UILabel> {
            $0.font = .customFont(ofSize: 17)
            $0.numberOfLines = 0
            $0.textColor = Colors.Base.title
        }
        
        static let description = Style<UILabel> {
            $0.font = .customFont(ofSize: 13)
            $0.numberOfLines = 0
            $0.textColor = Colors.Base.description
            $0.textAlignment = .center
        }
        
        static let cellValue = Style<UILabel> {
            $0.font = .customFont(ofSize: 14)
            $0.numberOfLines = 0
            $0.textColor = Colors.Cell.value
            $0.textAlignment = .center
        }
    }
    
    struct View {
        static let portraitButton = Style<UIButton> {
            $0.layer.masksToBounds = true
            $0.layer.cornerRadius = 50
            $0.widthAnchor.constraint(equalToConstant: 100).isActive = true;
            $0.heightAnchor.constraint(equalToConstant: 100).isActive = true;
            $0.backgroundColor = Colors.gray
        }
        
        static let dialogButton = Style<UIButton> {
            $0.titleLabel?.font = .mediumCustomFont(ofSize: 18)
            $0.layer.cornerRadius = 8
            $0.setTitleColor(Colors.Base.foreground, for: .normal)
            $0.heightAnchor.constraint(equalToConstant: 50).isActive = true;
        }
        
        static let detectButton = Style<UIButton> {
            $0.titleLabel?.font = .customFont(ofSize: 16)
            $0.layer.borderWidth = 0.5
            $0.layer.cornerRadius = 8
            $0.layer.borderColor = Colors.red.cgColor
            $0.setTitleColor(Colors.red, for: .normal)
        }
        
        static let permissionButton = Style<UIButton> {
            $0.titleLabel?.font = .customFont(ofSize: 14)
            $0.setTitleColor(Colors.blue, for: .normal)
            $0.contentMode = .center
            $0.titleLabel?.numberOfLines = 0
        }
    }
}


