//
//  BaseExpandTreeCell.swift
//  CTFit
//
//  Created by Mac on 2020/9/24.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import UIKit
import SnapKit
import TableViewManager

class BaseExpandTreeCell: BaseTableViewCell, ZJCellProtocol {
    
    // MARK: - ZJCellProtocol
    typealias ZJCelltemClass = BaseExpandTreeCellItem
    var item: BaseExpandTreeCellItem!
    override func cellWillAppear() {
        super.cellWillAppear()
        updateSeparatorInset()
    }
    
    // MARK: - Initialize
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: .value1, reuseIdentifier: reuseIdentifier)
    }

    override func layoutSubviews() {
        super.layoutSubviews()
        updateSeparatorInset()
    }
    
    private func updateSeparatorInset() {
        var rightMargin: CGFloat = 0
        if UIDevice.idiom == .pad { rightMargin = layoutMargins.right }
        if item.isExpand { rightMargin = CGFloat(Int.max) }
        separatorInset = UIEdgeInsets(top: 0, left: layoutMargins.left, bottom: 0, right: rightMargin)

    }
}
