//
//  File.swift
//  CTFit
//
//  Created by Mac on 2020/7/22.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit

class BaseTableViewCell: UITableViewCell {
    func cellWillAppear() { }
    
    // MARK: - Initialize
    
    @available(*, unavailable)
    required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override func prepareForReuse() {
        super.prepareForReuse()
        textLabel?.text = nil
        detailTextLabel?.text = nil
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        clipsToBounds = true
        backgroundColor = Colors.Cell.background
        Stylesheet.Label.title.apply(to: self.textLabel!)
        switch style {
        case .value1, .value2: Stylesheet.Label.cellValue.apply(to: self.detailTextLabel!)
        case .subtitle: Stylesheet.Label.description.apply(to: self.detailTextLabel!)
        default: break
        }
        clipsToBounds = true
    }
    
    lazy var arrowView: UIView = {
        let view = UIView(frame: arrowImageView.bounds)
        if UIDevice.idiom == .pad {
            view.width += Constraints.small
            arrowImageView.x = Constraints.small
        }
        view.addSubview(arrowImageView)
        return view
    } ()
    
    private lazy var arrowImageView: UIImageView = {
        let view = UIImageView(image: ImageRepo.Other.arrow)
        return view
    } ()
}

