//
//  CustomFooterView.swift
//  CTFit
//
//  Created by Mac on 2020/7/23.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit
 
let CustomFooterHeight:CGFloat = 20.0
let CustomFooterIdentifier = "CustomFooter"
let CustomFooterWidth:CGFloat = UIScreen.main.bounds.width
 
class CustomFooterView: UITableViewHeaderFooterView {
 
    // MARK: - Initialize
    @available(*, unavailable)
    required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    override func prepareForReuse() {
        super.prepareForReuse()
        textLabel?.text = nil
    }
    
    override var frame: CGRect {
        get { return super.frame }
        set (newFrame) {
            var frame = newFrame
            frame.size.height = CustomFooterHeight
            super.frame = frame
        }
    }
    
    fileprivate override init(reuseIdentifier: String?) {
        super.init(reuseIdentifier: reuseIdentifier)
        self.backgroundColor = Colors.Base.background
    }
    
    convenience init(title: String) {
        self.init(reuseIdentifier:nil)
        titleLabel.text = title
        setupConstraints()
    }
    
    // MARK: - View customer
    
    fileprivate func setupConstraints() {
        [titleLabel].forEach { view in
            view.translatesAutoresizingMaskIntoConstraints = false
            addSubview(view)
        }
        
        titleLabel.snp.makeConstraints { (make) in
            make.leading.equalTo(self.snp.leadingMargin)
            make.centerY.equalToSuperview()
        }
    }
    
    fileprivate lazy var titleLabel: UILabel = {
        let lable = UILabel(style: Stylesheet.Label.description)
        lable.textAlignment = .left
        return lable
    } ()
    
}
