//
//  CustomHeaderView.swift
//  CTFit
//
//  Created by Mac on 2020/7/23.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit
import SnapKit
 
let CustomHeaderHeight:CGFloat = 40.0
let CustomHeaderIdentifier = "CustomHeader"
let CustomHeaderWidth:CGFloat = UIScreen.main.bounds.width
 
class CustomHeaderView: UITableViewHeaderFooterView {
    
    // MARK: - Initialize
    
    @available(*, unavailable)
    required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override func prepareForReuse() {
        super.prepareForReuse()
        textLabel?.text = nil
    }
    
    override var frame: CGRect {
        get { return super.frame }
        set (newFrame) {
            var frame = newFrame
            frame.size.height = CustomHeaderHeight
            super.frame = frame
        }
    }
    
    fileprivate override init(reuseIdentifier: String?) {
        super.init(reuseIdentifier: reuseIdentifier)
        contentView.backgroundColor = Colors.Base.background
    }
    
    convenience init(title: String) {
        self.init(reuseIdentifier:nil)
        titleLabel.text = title
        setupConstraints()
    }
    
    // MARK: - View customer
    
    fileprivate func setupConstraints() {
        [titleLabel].forEach { view in
            view.translatesAutoresizingMaskIntoConstraints = false
            addSubview(view)
        }
        
        titleLabel.snp.makeConstraints { (make) in
            make.leading.equalTo(self.snp.leadingMargin)
            make.bottom.equalToSuperview().offset(-5)
        }
    }
    
    fileprivate lazy var titleLabel: UILabel = {
        let lable = UILabel(style: Stylesheet.Label.description)
        lable.textAlignment = .left
        return lable
    } ()
    
}

