//
//  AxisFormatterUtils.swift
//  CTFit
//
//  Created by Mac on 2020/6/4.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit
import Charts

struct AxisFormatterUtils {
    
    struct Step {
        
        class Day: NSObject, IAxisValueFormatter {
            func stringForValue(_ value: Double, axis: AxisBase?) -> String {
                let index = Int(value + 0.5);
                if index >= 0 && index < 24 && (index % 3 == 0) {
                    return String(index);
                }
                return "";
            }
        }
        
        class Week: NSObject,IAxisValueFormatter {
            
            func stringForValue(_ value: Double, axis: AxisBase?) -> String {
                let index = Int(value + 0.5);
                if index >= 0 && index < 7 {
                    let realIndex = (index + 0) % 7;
                    return CalendarUtils.kVeryShortWeekdaySymbols[realIndex];
                }
                return "";
            }
        }
        
        class Month: NSObject,IAxisValueFormatter {
            var days: Int = 31;
            func stringForValue(_ value: Double, axis: AxisBase?) -> String {
                let index = Int(value + 0.5);
                if index >= 0 && index < days && (index % 3 == 0) {
                    return String(index+1);
                }
                return "";
            }
        }

        class Year: NSObject,IAxisValueFormatter {
            func stringForValue(_ value: Double, axis: AxisBase?) -> String {
                let index = Int(value + 0.5);
                if index >= 0 && index < 12 {
                    return String(index + 1);
                }
                return "";
            }
        }
    }
}
    
extension AxisFormatterUtils {

    struct Exercise {
        
    }
}
   
extension AxisFormatterUtils {

    struct Sleep {
        
        class Day: NSObject, IAxisValueFormatter {
            func stringForValue(_ value: Double, axis: AxisBase?) -> String {
                let index = Int(value);
                if (index % 60) == 0 {
                    var hour = 20 + index / 60;
                    hour = hour % 24;
                    return String(hour);
                }
                return "";
            }
        }
        
        class Week: NSObject,IAxisValueFormatter {
            
            func stringForValue(_ value: Double, axis: AxisBase?) -> String {
                let index = Int(value + 0.5);
                if index >= 0 && index < 7 {
                    let realIndex = (index + 0) % 7;
                    return CalendarUtils.kVeryShortWeekdaySymbols[realIndex];
                }
                return "";
            }
        }
        
        class Month: NSObject,IAxisValueFormatter {
            var days: Int = 31;
            func stringForValue(_ value: Double, axis: AxisBase?) -> String {
                let index = Int(value + 0.5);
                if index >= 0 && index < days && (index % 3 == 0) {
                    return String(index+1);
                }
                return "";
            }
        }

        class Year: NSObject,IAxisValueFormatter {
            func stringForValue(_ value: Double, axis: AxisBase?) -> String {
                let index = Int(value + 0.5);
                if index >= 0 && index < 12 {
                    return String(index + 1);
                }
                return "";
            }
        }
        
        
    }
}

extension AxisFormatterUtils {
    
    struct Heart {
        class Day: NSObject, IAxisValueFormatter {
            func stringForValue(_ value: Double, axis: AxisBase?) -> String {
                guard let entries = axis?.entries,
                      let idx = entries.firstIndex(of: value) else { return "" }
                    if (idx % 3) == 0 {
                        return String(format: "%02d", idx);
                    } else {
                        return "⦁";
                    }
            }
        }
        
        class sleep: NSObject, IAxisValueFormatter {
            func stringForValue(_ value: Double, axis: AxisBase?) -> String {
                guard let entries = axis?.entries,
                      let idx = entries.firstIndex(of: value) else { return "" }
                    if (idx % 4) == 0 {
                        return String(format: "%02d", (idx+20)%24);
                    } else {
                        return "⦁";
                    }
            }
        }
    }
    
}

extension AxisFormatterUtils {

    struct Detect {
        class detect: NSObject, IAxisValueFormatter{
            var items :[BDDetect]?
            init(_ items :[BDDetect]?) {
                super.init();
                self.items = items
            }
            func stringForValue(_ value: Double, axis: AxisBase?) -> String {
                let index = Int(value);
                if let hasItems = items,  hasItems.count > index{
                    let item = hasItems[index];
                    return String(format: "%@\n%@", item.dateText, item.timeText)
                }
                return "";
            }
        }
        
        class OxygenLeft: NSObject, IAxisValueFormatter{
            func stringForValue(_ value: Double, axis: AxisBase?) -> String {
                let value = Int(value);
                if value <= 100 {
                    return "\(value)"
                }
                return "";
            }
        }
    }
}
