//
//  ChartsUtils.swift
//  CTFit
//
//  Created by Mac on 2020/6/4.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit
import Charts


class ChartsUtils {
    
    private static let textColor: UIColor = Colors.Chart.text
    
    private static let nodataColor: UIColor = Colors.Chart.separator

    private static let lineColor: UIColor = Colors.Chart.separator
    
    private static func baseBarChart(_ chart: BarChartView) {
        /// Chart Attributes
        chart.backgroundColor = .clear
        chart.noDataTextColor = nodataColor
        chart.noDataText = SRString.Base.nodata_describe.locastr
        chart.extraLeftOffset = Constraints.normal
        chart.extraRightOffset = Constraints.small

        chart.chartDescription?.enabled = false
        chart.dragEnabled = false
        chart.dragXEnabled = true
        chart.pinchZoomEnabled = false
        chart.setScaleEnabled(false)
        chart.legend.enabled = false
        chart.fitBars = true

        /// XAxis Attributes
        let xAxis = chart.xAxis
        xAxis.labelPosition = .bottom
        xAxis.gridColor = lineColor;
        xAxis.axisLineColor = lineColor
        xAxis.labelTextColor = textColor
        xAxis.labelFont = .customFont(ofSize: 11)
        xAxis.drawLabelsEnabled = true
        xAxis.centerAxisLabelsEnabled = true
        xAxis.drawAxisLineEnabled = false
        xAxis.drawGridLinesEnabled = true
        xAxis.axisLineWidth = 0.5
        xAxis.gridLineWidth = 0.5
        xAxis.axisLineDashLengths = [5, 5, 5] // 轴线虚线长度
        xAxis.gridLineDashLengths = [5, 5, 5] // 网格线虚线长度

        /// rightAxis Attributes
        let rightAxis = chart.rightAxis
        rightAxis.labelTextColor = textColor
        rightAxis.gridColor = lineColor
        rightAxis.zeroLineColor = lineColor
        rightAxis.axisLineColor = lineColor
        rightAxis.labelFont = .customFont(ofSize: 11)
        rightAxis.gridLineWidth = 0.5
        rightAxis.zeroLineWidth = 0.5
        
        rightAxis.drawLabelsEnabled = true
        rightAxis.drawTopYLabelEntryEnabled = true
        rightAxis.drawAxisLineEnabled = true
        rightAxis.drawZeroLineEnabled = true
        rightAxis.drawGridLinesEnabled = true
        
        chart.leftAxis.enabled = false
    }
    
    private static func baseLineChart(_ chart: LineChartView) {
        /// Chart Attributes
        chart.backgroundColor = .clear
        chart.noDataTextColor = nodataColor
        chart.noDataText = SRString.Base.nodata_describe.locastr
        chart.extraLeftOffset = Constraints.small
        chart.extraRightOffset = Constraints.normal

        chart.chartDescription?.enabled = false
        chart.dragEnabled = false
        chart.dragXEnabled = true
        chart.pinchZoomEnabled = false
        chart.setScaleEnabled(false)
        chart.legend.enabled = false

        /// XAxis Attributes
        let xAxis = chart.xAxis
        xAxis.labelPosition = .bottom
        xAxis.gridColor = lineColor;
        xAxis.axisLineColor = lineColor
        xAxis.labelTextColor = textColor
        xAxis.labelFont = .customFont(ofSize: 11)
        xAxis.drawLabelsEnabled = true
        xAxis.centerAxisLabelsEnabled = true
        xAxis.drawAxisLineEnabled = false
        xAxis.drawGridLinesEnabled = false
        xAxis.axisLineWidth = 0.5
        xAxis.gridLineWidth = 0.5
        xAxis.axisLineDashLengths = [5, 5, 5] // 轴线虚线长度
        xAxis.gridLineDashLengths = [5, 5, 5] // 网格线虚线长度
        
        /// leftAxis Attributes
        let leftAxis = chart.leftAxis
        leftAxis.labelTextColor = textColor
        leftAxis.gridColor = lineColor
        leftAxis.zeroLineColor = lineColor
        leftAxis.axisLineColor = lineColor
        leftAxis.labelFont = .customFont(ofSize: 11)
        leftAxis.gridLineWidth = 0.5
        leftAxis.zeroLineWidth = 0.5
        
        leftAxis.drawLabelsEnabled = true
        leftAxis.drawTopYLabelEntryEnabled = true
        leftAxis.drawAxisLineEnabled = true
        leftAxis.drawZeroLineEnabled = true
        leftAxis.drawGridLinesEnabled = true

        chart.rightAxis.enabled = false
    }
    
    static func upateMonthXAxis(_ chart: BarChartView, date: Date = Date()) {
        let xAxis = chart.xAxis;
        let num = CalendarUtils.calendar.daysInMonth(forDate: date)
        xAxis.axisMaxLabels = num+1; // Default is 25
        xAxis.setLabelCount(num+1, force: true);
        xAxis.axisMinimum = -0.5;
        xAxis.axisMaximum = Double(num) - 0.5;
    }
}

// MARK: - Step

extension ChartsUtils {
    
    struct Setp {
        
        static func day(_ chart: BarChartView) {
            baseBarChart(chart)
            chart.noDataText = SRString.Base.nodata_describe_step.locastr

            /// XAxis Attributes
            let xAxis = chart.xAxis
            xAxis.setLabelCount(25, force: true)
            xAxis.axisMinimum = -0.5
            xAxis.axisMaximum = 23.5
            xAxis.valueFormatter = AxisFormatterUtils.Step.Day()

            /// leftAxis Attributes
            let leftAxis = chart.leftAxis
            leftAxis.setLabelCount(5, force: true)
            leftAxis.axisMinimum = 0
            leftAxis.axisMaximum = 8000
            
            /// rightAxis Attributes
            let rightAxis = chart.rightAxis
            rightAxis.setLabelCount(5, force: true)
            rightAxis.axisMinimum = 0
            rightAxis.axisMaximum = 8000
                    
            /// Marker Attributes
            let marker = MarkerUtils.Step(); marker.chartView = chart
            chart.marker = marker
        }
        
        static func week(_ chart: BarChartView) {
            baseBarChart(chart)
            /// XAxis Attributes
            let xAxis = chart.xAxis
            xAxis.setLabelCount(8, force: true)
            xAxis.axisMinimum = -0.5
            xAxis.axisMaximum = 6.5
            xAxis.valueFormatter = AxisFormatterUtils.Step.Week()
                   
            /// leftAxis Attributes
            let leftAxis = chart.leftAxis
            leftAxis.setLabelCount(5, force: true)
            leftAxis.axisMinimum = 0
            leftAxis.axisMaximum = 16
            
            /// rightAxis Attributes
            let rightAxis = chart.rightAxis
            rightAxis.setLabelCount(5, force: true)
            rightAxis.axisMinimum = 0
            rightAxis.axisMaximum = 16

            /// Marker
            let marker = MarkerUtils.Distance(); marker.chartView = chart
            chart.marker = marker
               
        }
        
        static func month(_ chart: BarChartView) {
            baseBarChart(chart)
            /// XAxis Attributes
            let xAxis = chart.xAxis
            xAxis.axisMaxLabels = 31 // Default is 25
            xAxis.valueFormatter = AxisFormatterUtils.Step.Month()
            upateMonthXAxis(chart)
            
            /// leftAxis Attributes
            let leftAxis = chart.leftAxis
            leftAxis.setLabelCount(5, force: true)
            leftAxis.axisMinimum = 0
            leftAxis.axisMaximum = 16
            
            /// rightAxis Attributes
            let rightAxis = chart.rightAxis
            rightAxis.setLabelCount(5, force: true)
            rightAxis.axisMinimum = 0
            rightAxis.axisMaximum = 16

            /// Marker
            let marker = MarkerUtils.Distance(); marker.chartView = chart
            chart.marker = marker
        }
        
        static func year(_ chart: BarChartView) {
            baseBarChart(chart)
            
            /// XAxis Attributes
            let xAxis = chart.xAxis
            xAxis.setLabelCount(13, force: true)
            xAxis.axisMinimum = -0.5
            xAxis.axisMaximum = 11.5
            xAxis.valueFormatter = AxisFormatterUtils.Step.Year()
            
            /// leftAxis Attributes
            let leftAxis = chart.leftAxis
            leftAxis.setLabelCount(5, force: true)
            leftAxis.axisMinimum = 0
            leftAxis.axisMaximum = 400
            
            /// rightAxis Attributes
            let rightAxis = chart.rightAxis
            rightAxis.setLabelCount(5, force: true)
            rightAxis.axisMinimum = 0
            rightAxis.axisMaximum = 400

            /// Marker
            let marker = MarkerUtils.Distance(); marker.chartView = chart
            chart.marker = marker

        }
    }
}

// MARK: - 心率

extension ChartsUtils {
    
    struct HeartRate {
        
        static func day(_ chart: LineChartView) {
            baseLineChart(chart)
            chart.noDataText = SRString.Base.nodata_describe_heart.locastr

            /// XAxis Attributes
            let xAxis = chart.xAxis
            xAxis.setLabelCount(25, force: true)
            xAxis.axisMinimum = 0
            xAxis.axisMaximum = 143
            xAxis.valueFormatter = AxisFormatterUtils.Heart.Day()
            
            /// leftAxis Attributes
            let leftAxis = chart.leftAxis
            leftAxis.setLabelCount(5, force: true)
            leftAxis.axisMinimum = 40
            leftAxis.axisMaximum = 200
           
            /// Marker Attributes
            let marker = MarkerUtils.HeartDay(); marker.chartView = chart
            chart.marker = marker

        }
                
        static func exercise(_ chart: LineChartView) {
            baseLineChart(chart)
            chart.noDataText = SRString.Base.nodata_describe_heart_exercise.locastr
            chart.extraLeftOffset = Constraints.normal
            
            /// XAxis Attributes
            let xAxis = chart.xAxis
            xAxis.enabled = false
            
            /// leftAxis Attributes
            let leftAxis = chart.leftAxis
            leftAxis.setLabelCount(5, force: true)
            leftAxis.axisMinimum = 40
            leftAxis.axisMaximum = 200
           
            /// Marker Attributes
            let marker = MarkerUtils.ExerciseHeartRate(); marker.chartView = chart
            chart.marker = marker
        }
        
        
        static func sleep(_ chart: LineChartView) {
            baseLineChart(chart)
            chart.noDataText = SRString.Base.nodata_describe_heart_sleep.locastr
            chart.extraLeftOffset = Constraints.normal

            /// XAxis Attributes
            let xAxis = chart.xAxis
            xAxis.setLabelCount(17, force: true);
            xAxis.axisMinimum = 0;
            xAxis.axisMaximum = 95;
            xAxis.valueFormatter = AxisFormatterUtils.Heart.sleep()
            
            /// leftAxis Attributes
            let leftAxis = chart.leftAxis
            leftAxis.setLabelCount(5, force: true)
            leftAxis.axisMinimum = 40
            leftAxis.axisMaximum = 200
           
            /// Marker Attributes
            let marker = MarkerUtils.SleepHeart(); marker.chartView = chart
            chart.marker = marker
        }
        
    }
}

// MARK: - 睡眠

extension ChartsUtils {
    
    struct Sleep {
        
        static func day(_ chart: BarChartView) {
            baseBarChart(chart)
            chart.noDataText = SRString.Base.nodata_describe_sleep.locastr

            // chart.dragEnabled = true
            chart.extraLeftOffset = Constraints.normal
            chart.extraRightOffset = Constraints.normal

            /// XAxis Attributes
            let xAxis = chart.xAxis
            xAxis.drawAxisLineEnabled = true
            xAxis.setLabelCount(17, force: true)
            xAxis.axisMinimum = 0
            xAxis.axisMaximum = 960
            xAxis.valueFormatter = AxisFormatterUtils.Sleep.Day()
            
            /// YAxis Attributes
            let leftAxis = chart.leftAxis;
            leftAxis.axisMinimum = 0;
            leftAxis.axisMaximum = 20;
            
            chart.rightAxis.enabled = false
            
            /// Marker Attributes
            let marker = MarkerUtils.SleepDay(); marker.chartView = chart
            chart.marker = marker

        }
        
        static func week(_ chart: BarChartView) {
            baseBarChart(chart)
            /// XAxis Attributes
            let xAxis = chart.xAxis
            xAxis.setLabelCount(8, force: true)
            xAxis.axisMinimum = -0.5
            xAxis.axisMaximum = 6.5
            xAxis.valueFormatter = AxisFormatterUtils.Sleep.Week()
                   
            /// leftAxis
            let leftAxis = chart.leftAxis
            leftAxis.setLabelCount(5, force: true)
            leftAxis.axisMinimum = 0
            leftAxis.axisMaximum = 16
            
            /// rightAxis Attributes
            let rightAxis = chart.rightAxis
            rightAxis.setLabelCount(5, force: true)
            rightAxis.axisMinimum = 0
            rightAxis.axisMaximum = 16

            /// Marker
            let marker = MarkerUtils.SleepInterval(); marker.chartView = chart
            chart.marker = marker
               
        }
        
        static func month(_ chart: BarChartView) {
            baseBarChart(chart)
            /// XAxis Attributes
            let xAxis = chart.xAxis
            xAxis.axisMaxLabels = 31 // Default is 25
            xAxis.valueFormatter = AxisFormatterUtils.Sleep.Month()
            upateMonthXAxis(chart)
            
            /// leftAxis
            let leftAxis = chart.leftAxis
            leftAxis.setLabelCount(5, force: true)
            leftAxis.axisMinimum = 0
            leftAxis.axisMaximum = 16
            
            /// rightAxis Attributes
            let rightAxis = chart.rightAxis
            rightAxis.setLabelCount(5, force: true)
            rightAxis.axisMinimum = 0
            rightAxis.axisMaximum = 16

            /// Marker
            let marker = MarkerUtils.SleepInterval(); marker.chartView = chart
            chart.marker = marker
        }
        
        static func year(_ chart: BarChartView) {
            baseBarChart(chart)
            
            /// XAxis Attributes
            let xAxis = chart.xAxis
            xAxis.setLabelCount(13, force: true)
            xAxis.axisMinimum = -0.5
            xAxis.axisMaximum = 11.5
            xAxis.valueFormatter = AxisFormatterUtils.Sleep.Year()
                   
            /// leftAxis
            let leftAxis = chart.leftAxis
            leftAxis.setLabelCount(5, force: true)
            leftAxis.axisMinimum = 0
            leftAxis.axisMaximum = 400
            
            /// rightAxis Attributes
            let rightAxis = chart.rightAxis
            rightAxis.setLabelCount(5, force: true)
            rightAxis.axisMinimum = 0
            rightAxis.axisMaximum = 400

            /// Marker
            let marker = MarkerUtils.SleepInterval(); marker.chartView = chart
            chart.marker = marker
               
        }
    }
}



// MARK: - Speed
extension ChartsUtils {
    struct Sport {
        static func speed(_ chart: LineChartView) {
            baseLineChart(chart)

            /// XAxis Attributes
            let xAxis = chart.xAxis
            xAxis.enabled = false
            
            /// leftAxis Attributes
            let leftAxis = chart.leftAxis
            leftAxis.labelTextColor = Colors.white
            leftAxis.setLabelCount(5, force: true)
            leftAxis.axisMinimum = 0
            leftAxis.axisMaximum = 25
           
            /// Marker Attributes
            let marker = MarkerUtils.SportSpeed(); marker.chartView = chart
            chart.marker = marker
        }
    }
}


// MARK: - 手动检测

extension ChartsUtils {
    struct Detect {
        
        static func detect(_ chart: LineChartView) {
            baseLineChart(chart)
            chart.extraLeftOffset = Constraints.normal;
            chart.extraTopOffset = Constraints.small;
            chart.extraBottomOffset = Constraints.small;
            
            chart.dragXEnabled = true
            chart.setVisibleXRangeMaximum(6)

            /// XAxis Attributes
            let xAxis = chart.xAxis
            xAxis.labelFont = .customFont(ofSize: 10)
            xAxis.centerAxisLabelsEnabled = false
            xAxis.drawGridLinesEnabled = false
            
            xAxis.setLabelCount(7, force: true)
            xAxis.axisMinimum = 0;
            xAxis.axisMaximum = 6;

            /// leftAxis Attributes
            let leftAxis = chart.leftAxis
            leftAxis.labelFont = .customFont(ofSize: 10)
            leftAxis.setLabelCount(5, force: true)
            leftAxis.axisMinimum = 40
            leftAxis.axisMaximum = 200
        }
    }
}
