//
//  TextFieldDelegateWrapper.swift
//  CTFit
//
//  Created by Mac on 2020/7/17.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit

class TextFieldDelegateWrapper: NSObject {
    

    var maxLenght: Int = 128
    
    func setDidChangedClosure(_ closure: @escaping InputStateClosure) { didChangedClosure = closure }

    func setEndEditClosure(_ closure: @escaping InputStateClosure) { endEditClosure = closure }

    func setInputFilterClosure(_ closure: @escaping InputFilterClosure) { inputFilterClosure = closure }

    override init() {
        super.init()
    }
    
    convenience init(with maxLength: Int = 128) {
        self.init()
        self.maxLenght = maxLenght
    }
    
    
    private func filterInputField(_ resultString: String, replaceString: String) -> Bool {
        let utf8String = resultString.utf8CString
        if utf8String.count > maxLenght+1 { return false }
        if let closure = inputFilterClosure { return closure(resultString) }
        return true
    }
    
    // private
    
    typealias InputStateClosure = (_ text:String)->Void
    
    typealias InputFilterClosure = (_ replaceString:String)->Bool

    private var didChangedClosure: InputStateClosure?
    
    private var endEditClosure: InputStateClosure?
    
    private var inputFilterClosure: InputFilterClosure?
}

extension TextFieldDelegateWrapper: UITextFieldDelegate {
    
    func textFieldShouldReturn(_ textField: UITextField) -> Bool {
        textField.resignFirstResponder()
    }

    func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange, replacementString string: String) -> Bool {
        let str: NSString = (textField.text ?? "" ) as NSString
        let resultString = str.replacingCharacters(in: range, with: string)
        let result = filterInputField(resultString, replaceString: string)
        if result, let closure = didChangedClosure { closure(resultString) }
        return result
    }

    func textFieldDidEndEditing(_ textField: UITextField) {
        if let closure = endEditClosure { closure(textField.text ?? "") }
    }

}

extension TextFieldDelegateWrapper {
    static func resignKeyboard() {
        UIApplication.shared.keyWindow?.resignFirstResponder()
    }
}
