//
//  ToastUtils.swift
//  CTFit
//
//  Created by Mac on 2020/6/18.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Toast

struct ToastUtils {
    
    private static var tosatStyle: ToastStyle {
        ToastManager.shared.isQueueEnabled = false;
        ToastManager.shared.isTapToDismissEnabled = true;
        var style = ToastStyle()
        style.messageFont = UIFont.customFont(ofSize: 14)
        style.displayShadow = true;
        style.backgroundColor = Colors.black
        style.messageColor = Colors.white
        style.messageAlignment = .center
        return style
    }
    
    private static var normalTosatStyle: ToastStyle = {
        var style = tosatStyle
        return tosatStyle
    }()
    
    private static var successTosatStyle: ToastStyle = {
        let style = tosatStyle
        return style
    }()

    private static var errorTosatStyle: ToastStyle = {
        var style = ToastStyle()
        style.backgroundColor = .red
        return style
    }()
    
    private static var protocolTosatStyle: ToastStyle = {
        var style = tosatStyle
        style.messageAlignment = .left
        return tosatStyle
    }()
    
    private static var keyWindow: UIWindow? { Helper.keyWindow }
    
    private static var ccView: UIView? { Helper.currentVc?.view }

}

/// Activity
extension ToastUtils {
    
    /// to view customer
    static func showActivity(to view: UIView?) { view?.makeToastActivity(.center) }
    static func hideActivity(to view: UIView?) { view?.hideToastActivity() }

    /// to keyWindow
    static func showActivity() {  showActivity(to: keyWindow) }
    static func hideActivity() { hideActivity(to: keyWindow) }
    
    /// to current controller.view
    static func showActivityCCV() {  showActivity(to: ccView) }
    static func hideActivityCCV() { hideActivity(to: ccView) }
}

/// Toast
extension ToastUtils {
    
    /// to current controller.view
    static func showToast(normal string: String, to view: UIView?, duration: TimeInterval = 3.0) {
        view?.hideAllToasts()
        view?.makeToast(string, duration: duration, position: .bottom, style: normalTosatStyle)
    }
    static func showToast(success string: String, to view: UIView?, duration: TimeInterval = 3.0) {
        view?.hideAllToasts()
        view?.makeToast(string, duration: duration, position: .bottom, style: successTosatStyle)
    }
    static func showToast(error string: String, to view: UIView?, duration: TimeInterval = 3.0) {
        view?.hideAllToasts()
        view?.makeToast(string, duration: duration, position: .bottom, style: errorTosatStyle)
    }
    static func hideAllToast(to view: UIView?) {
        view?.hideAllToasts()
    }
    
    /// to keyWindow
    static func showToast(normal string: String, duration: TimeInterval = 3.0) { showToast(normal: string, to: keyWindow, duration: duration)}
    static func showToast(success string: String) { showToast(success: string, to: keyWindow)}
    static func showToast(error string: String) { showToast(error: string, to: keyWindow)}
    static func hideAllToast() { keyWindow?.hideAllToasts() }

    
    
    /// to view customer
    static func showToastCCV(normal string: String, duration: TimeInterval = 3.0) { showToast(normal: string, to: ccView, duration: duration)}
    static func showToastCCV(success string: String) { showToast(success: string, to: ccView)}
    static func showToastCCV(error string: String) { showToast(error: string, to: ccView)}
    static func hideAllToastCCV() { ccView?.hideAllToasts() }
    static func showToastCCV(data string: String, duration: TimeInterval = 30.0) { showToast(error: string, to: keyWindow, duration: duration)}
}


