//
//  UncaughtExceptionHandle.swift
//  CTFit
//
//  Created by Mac on 2020/8/11.
//  Copyright © 2020 shirajo. All rights reserved.
//
//  捕获异常

import Foundation
import RxBluetoothKit

fileprivate let ExceptionLog = Logging(module: "EXCEPTION", std: .warning, file: .warning)
class UncaughtExceptionHandle {
    static func standard() {
        NSSetUncaughtExceptionHandler { (exception) in
            let arr:NSArray = exception.callStackSymbols as NSArray
            let reason:String = exception.reason!
            let name:String = exception.name.rawValue
            ExceptionLog.e("""
                Name: \(name)
                Reason: \(reason)
                CallStackSymbols: \(arr.componentsJoined(by: "\n"))
                """)
        }
    }
}
