//
//  ApplicationDatasource.swift
//  CTFit
//
//  Created by Mac on 2020/9/30.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import Foundation
import RxSwift
import TableViewManager

final class ApplicationDatasource {
    
    lazy var items: [BaseTableViewItem] = [BaseTableViewItem]()
    
    init() {
        if !ApplicationDatasource.tabbarStyle {
            items.append(backgroundSoundItem)
        }
        items.append(homeStyleItem)
        ApplicationItemType.collection.forEach { (type) in
            items.append(ApplicationItem(type))
        }
    }
    
    private lazy var backgroundSoundItem: SwitchItem = {
        let item = SwitchItem(with: .background_sound, isOn: ApplicationDatasource.sound)
        item.cellHeight = 60
        item.setOnValueChanged { (sound) in
            ApplicationDatasource.sound = sound
        }
        return item
    } ()
    
    private lazy var homeStyleItem: SwitchItem = {
        let item = SwitchItem(with: .homeStyle, isOn: ApplicationDatasource.tabbarStyle)
        item.cellHeight = 60
        item.setOnValueChanged { (style) in
            guard ApplicationDatasource.tabbarStyle != style else { return }
            ApplicationDatasource.tabbarStyle = style
            ApplicationDatasource.switchHomePage()
        }
        return item
    } ()
}

// MARK: - 数据缓存 SoundEffect
extension ApplicationDatasource {
    
    private static let key = "UserDefaults_Key:SoundEffect"
    static var sound: Bool {
        get {
            if UserDefaults.standard.object(forKey: key) != nil {
                return UserDefaults.standard.bool(forKey: key)
            }
            return true
        }
        set {
            UserDefaults.standard.setValue(newValue, forKey: key)
            UserDefaults.standard.synchronize()
        }
    }
}

// MARK: - 数据缓存 tabbarStyle,
extension ApplicationDatasource {
    private static let style_key = "UserDefaults_Key:HomeStyle"
    public static var tabbarStyle: Bool {
        get {
            if UserDefaults.standard.object(forKey: style_key) != nil {
                return UserDefaults.standard.bool(forKey: style_key)
            }
            return false
        }
        set {
            UserDefaults.standard.setValue(newValue, forKey: style_key)
            UserDefaults.standard.synchronize()
        }
    }
    
    private static func switchHomePage() {
        guard let delegate = UIApplication.shared.delegate as? AppDelegate else { return }
        delegate.enterToHomeController(first: false)
    }
}
