//
//  AboutViewController.swift
//  CTFit
//
//  Created by Mac on 2020/9/30.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import UIKit

class AboutViewController: BaseViewController {
    
    override init() {
        super.init()
        navigationItem.title = SRString.Application.about.locastr
        modalPresentationStyle = .fullScreen
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        addSubviews()
        setupConstraints()
    }
    
    private func addSubviews() {
        let items = [imageView, appNameLabel, appVersionLabel, appCopyRightLabel]
        items.forEach { e in
            e.translatesAutoresizingMaskIntoConstraints = false
            view.addSubview(e)
        }
    }

    private func setupConstraints() {
        imageView.snp.makeConstraints { (make) in
            make.centerX.equalToSuperview();
            make.centerY.equalToSuperview().offset(-80);
        }
        appNameLabel.snp.makeConstraints { (make) in
            make.centerX.equalToSuperview();
            make.top.equalTo(imageView.snp.bottom).offset(16);
        }
        appVersionLabel.snp.makeConstraints { (make) in
            make.centerX.equalToSuperview();
            make.top.equalTo(appNameLabel.snp.bottom).offset(8);
        }
        appCopyRightLabel.snp.makeConstraints { (make) in
            make.centerX.equalToSuperview();
            make.bottom.equalToSuperview().offset( -32 - UIDevice.bottomLayoutGuide);
        }
    }
    
    // MARK: - View customer
    
    private lazy var imageView: UIImageView = {
        let view = UIImageView();
        view.image = AppUtils.icon;
        view.borderCorner = 8;
        return view
    } ()
    private lazy var appNameLabel: UILabel = {
        let label = UILabel(style: Stylesheet.Label.description)
        label.text = AppUtils.shared.name
        return label
    } ()
    
    private lazy var appVersionLabel: UILabel = {
        let label = UILabel(style: Stylesheet.Label.description)
        label.text = SRString.Application.application_version.locastr + AppUtils.shared.version
        return label
    } ()
    
    private lazy var appCopyRightLabel: UILabel = {
        let label = UILabel(style: Stylesheet.Label.description)
        label.text = "Shirajo© Copyright 2016-2019"
        return label
    } ()

    
}
