//
//  AppleHealthViewController.swift
//  CTFit
//
//  Created by Mac on 2020/9/30.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import UIKit

class AppleHealthViewController: BaseViewController {
    
    override init() {
        super.init()
        navigationItem.title = SRString.Application.apple_health.locastr
        modalPresentationStyle = .fullScreen
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        addSubviews()
    }
    
    // MARK: - View customer
    private func addSubviews() {
        let items = [descriptionLabel]
        items.forEach { e in
            e.translatesAutoresizingMaskIntoConstraints = false
            view.addSubview(e)
        }
        descriptionLabel.snp.makeConstraints { (make) in
            make.left.top.equalToSuperview().offset(Constraints.medium)
            make.right.equalToSuperview().offset(-Constraints.medium)
        }
    }

    private lazy var descriptionLabel: UILabel = {
        let label = UILabel(style: Stylesheet.Label.text)
        label.textAlignment = .justified
        label.text = SRString.Application.apple_health_describe.locastr
        return label
    } ()
}
