//
//  PersonalDataCell.swift
//  CTFit
//
//  Created by Mac on 2020/12/15.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import UIKit
import SnapKit
import TableViewManager

final class PersonalDataCell: BaseTableViewCell, ZJCellProtocol {

    // MARK: - ZJCellProtocol
    var item: PersonalDataItem!
    typealias ZJCelltemClass = PersonalDataItem
    override func cellWillAppear() {
        textLabel?.text = item.text
        detailTextLabel?.text = item.detailText
    }
    
    // MARK: - Initialize
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: .value1, reuseIdentifier: reuseIdentifier)
        imageView?.image = ImageRepo.Other.file
    }
}
