//
//  PersonalDataItem.swift
//  CTFit
//
//  Created by Mac on 2020/12/15.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import Foundation
import TableViewManager

final class PersonalDataItem: BaseTableViewItem {
    
    var fileURL: URL { item.fileUrl }
    
    // MARK: - Cell source
    var text: String { item.fileName }
    var detailText: String { item.latestTimeStr }

    // MARK: - Initialize
    private override init() {
        super.init()
        editingStyle = .delete
        accessoryType = .none
    }
    
    convenience init(with item: CSVFile) {
        self.init()
        self.item = item
        setSelectionHandler { [weak self] (item) in
            guard let strong = self else { return }
            strong.onSelectedHandler()
        }
    }
    
    private var item: CSVFile!
    private lazy var previewManager: SRFilePreviewManager = SRFilePreviewManager()
    private lazy var previewVc: UIViewController = previewManager.instanced(for: fileURL, fromNavigation: true)

}
extension PersonalDataItem {
    private func onSelectedHandler() {
        present(previewVc)
    }
    
    private func present(_ vc: UIViewController) {
        vc.navigationItem.leftBarButtonItem = cancelBarItem()
        let naviVc = UINavigationController(rootViewController: vc)
        naviVc.modalPresentationStyle = .fullScreen
        naviVc.navigationBar.isTranslucent = false;
        Helper.currentVc?.present(naviVc, animated: true, completion: nil)
    }
    
    @objc private func cancelBarItem() -> UIBarButtonItem { /// 返回
        let item = UIBarButtonItem(title: SRString.Base.cancel.locastr, style: .plain, target: self, action: #selector(onCancel))
        return item;
    }
    
    @objc private func onCancel(){
        Helper.currentVc?.navigationController?.dismiss(animated: true, completion: nil)
    }
}
