//
//  ClockSettingDatasource.swift
//  CTFit
//
//  Created by Mac on 2020/7/13.
//  Copyright © 2020 shirajo. All rights reserved.
//


import Foundation

final class ClockSettingDatasource {
    
    typealias DatasouceDidChangedClosure = ()->Void
    func setOnDatasouceDidChanged(_ block: @escaping DatasouceDidChangedClosure) {
        self.datasouceDidChangedClosure = block
    }
    
    lazy var clockAddItem: AlarmAddItem = AlarmAddItem(with: .clock)
    lazy var scheduleAddItem: AlarmAddItem = AlarmAddItem(with: .schedule)
    lazy var clockItems: [ClockItem] = [ClockItem]()
    lazy var scheduleItems: [ScheduleItem] = [ScheduleItem]()
    
    // MARK: - Initialize
    
    deinit { save() }
    init() {
        clockInfo.clockArray.forEach { (anClock) in loadClockItem(anClock) }
        clockInfo.scheduleArray.forEach { (anSchedule) in loadScheduleItem(anSchedule) }
        clockAddItem.setSelectionHandler { [weak self] (item) in
            guard let strong = self else { return }
            let anClock = BDClockItem()
            strong.addClockItem(anClock)
        }
        scheduleAddItem.setSelectionHandler { [weak self] (item) in
            guard let strong = self else { return }
            let anSchedule = BDScheduleItem()
            strong.addScheduleItem(anSchedule)
        }
    }
    
    
       
    
    // MARK: - private field
    private var datasouceDidChangedClosure: DatasouceDidChangedClosure? = nil
    private let clockInfo = BDClockInfo.band
}

extension ClockSettingDatasource {
    
    private func alert(_ message: String,  okHander: @escaping AlertHandler) {
        AlertManager.show(title: nil, message: message, okHander: okHander) { (_) in }
    }
    
    private func loadClockItem(_ anClock: BDClockItem) {
        let anItem = ClockItem(with: anClock)
        clockItems.append(anItem)
        anItem.setDeletionHandler { [weak self] (item) in
            guard let strong = self, let clockItem = item as? ClockItem else { return }
            strong.alert(SRString.Clock.delete_clock_alert.locastr) { (_) in
                strong.deleteClockItem(clockItem)
            }
        }
    }
    
    private func loadScheduleItem(_ anSchedule: BDScheduleItem) {
        let anItem = ScheduleItem(with: anSchedule)
        scheduleItems.append(anItem)
        anItem.setDeletionHandler { [weak self] (item) in
            guard let strong = self, let scheduleItem = item as? ScheduleItem else { return }
            strong.alert(SRString.Clock.delete_schedule_alert.locastr) { (_) in
                strong.deleteScheduleItem(scheduleItem)
            }
        }
    }
    
    private func deleteClockItem(_ item: ClockItem) {
        clockInfo.clockArray.removeAll { (e) -> Bool in e == item.clockItem }
        clockItems.removeAll { (e) -> Bool in e == item }
        datasouceDidChangedClosure?()
    }
    private func deleteScheduleItem(_ item: ScheduleItem) {
        clockInfo.scheduleArray.removeAll { (e) -> Bool in e == item.scheduleItem }
        scheduleItems.removeAll { (e) -> Bool in e == item }
        datasouceDidChangedClosure?()
    }
    
    private func addClockItem(_ clockItem: BDClockItem) {
        let vc = ClockItemViewController(with: clockItem, isAdd: true)
        Helper.currentVc?.navigationController?.pushViewController(vc, animated: true)
        vc.onDidChangedClosure { [weak self] obj in
            guard let strong = self, let clockItem = obj as? BDClockItem,
                let closure = strong.datasouceDidChangedClosure else { return }
            strong.clockInfo.clockArray.append(clockItem)
            strong.loadClockItem(clockItem)
            closure()
        }
    }
    
    private func addScheduleItem(_ scheduleItem: BDScheduleItem) {
        let vc = ScheduleItemViewController(with: scheduleItem, isAdd: true)
        Helper.currentVc?.navigationController?.pushViewController(vc, animated: true)
        vc.onDidChangedClosure { [weak self] obj in
            guard let strong = self, let scheduleItem = obj as? BDScheduleItem,
                let closure = strong.datasouceDidChangedClosure else { return }
            strong.clockInfo.scheduleArray.append(scheduleItem)
            strong.loadScheduleItem(scheduleItem)
            closure()
        }
    }
    
    private func save() { BandCommand.save(clockInfo) }
}


