//
//  ClockSettingViewController.swift
//  CTFit
//
//  Created by Mac on 2020/7/13.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation
import TableViewManager

class ClockSettingViewController: BaseViewController, CustomView {
    
    typealias ViewClass = BaseTableView
    
    override init() {
        super.init()
        hidesBottomBarWhenPushed = true
        navigationItem.title = SRString.Clock.clock_setting.locastr
    }
    
    override func loadView() {
        super.loadView()
        view = ViewClass()
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        setupTableView()
    }
    
    // MARK: - tableViewManger
    
    private lazy var datasource: ClockSettingDatasource = ClockSettingDatasource()
    
    private lazy var tableViewManger: ZJTableViewManager = {
        let manager = ZJTableViewManager(tableView: customView.tableView)
        manager.register(ClockCell.self, ClockItem.self)
        manager.register(ScheduleCell.self, ScheduleItem.self)
        manager.register(AlarmAddCell.self, AlarmAddItem.self)
        manager.add(section: clockSection)
        if BandConnect.protocolType == .series_z { manager.add(section: scheduleSection) }
        return manager
    } ()
    
    private lazy var clockSection: ZJTableViewSection = {
        let section = BaseTableViewSection(customHeader: SRString.Clock.clock_reminder.locastr)
        return section
    } ()
    
    private lazy var scheduleSection: ZJTableViewSection = {
        let section = BaseTableViewSection(customHeader: SRString.Clock.schedules_reminder.locastr)
        return section
    } ()
    
    private func setupTableView() {
        loadCells()
        datasource.setOnDatasouceDidChanged { [weak self] in
            guard let strong = self else { return }
            strong.loadCells()
        }
    }
    
    private func loadCells() {
        clockSection.removeAllItems()
        for anClock in datasource.clockItems { clockSection.add(item: anClock) }
        if datasource.clockItems.count < 4 { clockSection.add(item: datasource.clockAddItem) }
        
        scheduleSection.removeAllItems()
         for anSchedule in datasource.scheduleItems { scheduleSection.add(item: anSchedule) }
        if datasource.scheduleItems.count < 4 { scheduleSection.add(item: datasource.scheduleAddItem) }
        tableViewManger.reload()
    }
}
