//
//  ClockItemDatasource.swift
//  CTFit
//
//  Created by Mac on 2020/7/15.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation

final class ClockItemDatasource {
    
    let clockItem: BDClockItem
        
    lazy var datePickerItem: DatePickerItem = DatePickerItem(with: .time, andDate: clockItem.date)
    
    lazy var repeatItem: RepeatItem = RepeatItem(with: clockItem.repeats)
    
    lazy var vibrateItem: VibrateItem = { VibrateItem(with: clockItem.vibrate.copy()) } ()
    
    lazy var fieldItem: FieldItem = FieldItem(with: .label, content: clockItem.label, maxLenght: 15)

    init(with item: BDClockItem = BDClockItem()) {
        clockItem = item

        datePickerItem.setDateDidChangedClosure { [weak self] in
            guard let strong = self else { return }
            strong.clockItem.date = strong.datePickerItem.date
        }
        
        repeatItem.setDidChangedClosure { [weak self] in
            guard let strong = self else { return }
            strong.clockItem.repeats = strong.repeatItem.repeats
        }
        
        vibrateItem.setValueChanged { [weak self] (vibrate) in
            guard let strong = self else { return }
            strong.clockItem.vibrate = vibrate
        }
        
        fieldItem.setDidChangedClosure { [weak self] in
            guard let strong = self else { return }
            strong.clockItem.label = strong.fieldItem.content ?? ""
        }
    }
}

