//
//  ClockItemViewController.swift
//  CTFit
//
//  Created by Mac on 2020/7/15.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation
import TableViewManager

class ClockItemViewController: BaseViewController, CustomView {
    
    typealias ViewClass = BaseTableView
        
    // MARK: - override
    
    override private init() {
        super.init()
        navigationItem.title = SRString.Clock.clock_reminder.locastr
    }
    
    convenience init(with clockItem: BDClockItem, isAdd:Bool = false) {
        self.init()
        self.isAdd = isAdd
        datasource = ClockItemDatasource(with: clockItem)
    }
    
    override func loadView() {
        super.loadView()
        view = ViewClass()
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        setupTableView()
    }
    
    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated)
        if !isAdd { onDidChanged(model: datasource.clockItem) }
    }
    
    override func viewDidDisappear(_ animated: Bool) {
        super.viewDidDisappear(animated)
        if !isAdd { onDidChanged(model: datasource.clockItem) }
    }

    override func initNavigationBar() {
        super.initNavigationBar()
        if isAdd { self.navigationItem.rightBarButtonItem = addBarItem() }
    }
    
    override func onAdd(_ sender: UIBarButtonItem) {
        onDidChanged(model: datasource.clockItem)
        super.onAdd(sender)
    }

    // MARK: - tableViewManger
    
    private func setupTableView() {
        customView.tableView.backgroundColor =  Colors.darkMode(Colors.black, .groupTableViewBackground)
        tableViewManger.reload()
    }
    
    private lazy var isAdd: Bool = false
    
    private lazy var datasource: ClockItemDatasource = ClockItemDatasource()
    
    private lazy var tableViewManger: ZJTableViewManager = {
        let manager = ZJTableViewManager(tableView: customView.tableView)
        manager.register(DatePickerCell.self, DatePickerItem.self)
        manager.register(RepeatCell.self, RepeatItem.self)
        manager.register(VibrateCell.self, VibrateItem.self)
        manager.register(FieldCell.self, FieldItem.self)
        manager.add(section: datePickerSection)
        manager.add(section: selectSection)
        if BandConnect.protocolType == .series_z { manager.add(section: labelSection) }
        return manager
    } ()
    
    private lazy var datePickerSection: ZJTableViewSection = {
        let section = ZJTableViewSection()
        section.headerHeight = 0.01; section.footerHeight = 0.01;
        section.add(item: datasource.datePickerItem)
        return section
    } ()
    
    private lazy var selectSection: ZJTableViewSection = {
        let section = ZJTableViewSection()
        section.headerHeight = Constraints.large; section.footerHeight = 0.01;
        section.add(item: datasource.repeatItem)
        if BandConnect.protocolType == .series_z { section.add(item: datasource.vibrateItem) }
        return section
    } ()
    
    private lazy var labelSection: ZJTableViewSection = {
        let section = BaseTableViewSection(customFooter: SRString.Clock.label_hint_clock.locastr)
        section.headerHeight = Constraints.large; section.footerHeight = Constraints.normal;
        section.add(item: datasource.fieldItem)
        return section
    } ()
}

