//
//  RepeatDatasource.swift
//  CTFit
//
//  Created by Mac on 2020/7/16.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation

final class RepeatDatasource {
    
    var repeats: [BDWeekType]

    var weekSelectItems: [WeekSelectItem] = []
    
    init(with repeats: [BDWeekType] ) {
        self.repeats = repeats
        
        BDWeekType.collection.forEach { (type) in
            var selected = false
            if repeats.contains(type) { selected = true }
            let item = WeekSelectItem(with: type, selected: selected)
            weekSelectItems.append(item)
            item.setValueChanged { [weak self] (selected) in
                guard let strong = self else { return }
                if !strong.repeats.contains(type), selected {
                    strong.repeats.append(type)
                } else if strong.repeats.contains(type), !selected {
                    strong.repeats.removeAll { (e) -> Bool in e == type }
                }
            }
        }
    }       
}
