//
//  RepeatViewController.swift
//  CTFit
//
//  Created by Mac on 2020/7/15.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation
import TableViewManager

class RepeatViewController: BaseViewController, CustomView {
    
    typealias ViewClass = BaseTableView
        
    // MARK: - override
    
    override private init() {
        super.init()
        navigationItem.title = SRString.Vibrate.repeat.locastr
    }
    
    convenience init(with repeats: [BDWeekType]) {
        self.init()
        datasource = RepeatDatasource(with: repeats)
    }
    
    override func loadView() {
        super.loadView()
        view = ViewClass()
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        setupTableView()
    }
    
    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated)
        onDidChanged(model: datasource.repeats)
    }

    override func initNavigationBar() {
        super.initNavigationBar()
    }
    
    // MARK: - tableViewManger
    
    private func setupTableView() {
        tableViewManger.reload()
    }
    
    private lazy var datasource: RepeatDatasource = RepeatDatasource(with: [])
    
    private lazy var tableViewManger: ZJTableViewManager = {
        let manager = ZJTableViewManager(tableView: customView.tableView)
        manager.register(WeekSelectCell.self, WeekSelectItem.self)
        manager.add(section: weekSelectSection)
        return manager
    } ()
    
    private lazy var weekSelectSection: ZJTableViewSection = {
        let section = ZJTableViewSection()
        section.headerHeight = 0.01; section.footerHeight = 0.01;
        datasource.weekSelectItems.forEach { (e) in section.add(item: e) }
        return section
    } ()
}
