//
//  WeekSelectItem.swift
//  CTFit
//
//  Created by Mac on 2020/7/16.
//  Copyright © 2020 shirajo. All rights reserved.
//


import Foundation
import TableViewManager

extension BDWeekType {
    var index: Int {
        switch self {
        case .sun: return 0
        case .mon: return 1
        case .tue: return 2
        case .wed: return 3
        case .thu: return 4
        case .fri: return 5
        case .sat: return 6
        }
    }
}

final class WeekSelectItem: BaseTableViewItem {
    
    
    var type: BDWeekType = .sun
        
    var selected: Bool = false
    
    var text: String { CalendarUtils.kWeekdaySymbols[type.index] }
        
    func setIsOn(_ isOn: Bool) {
        selected = isOn
        if let closure = didChangedClosure { closure(isOn) }
    }
    
    func setValueChanged(_ closure: @escaping ValueChangedClosure) {
        self.didChangedClosure = closure
    }
    
    // MARK: - Initialize

    private override init() {
        super.init()
        selectionStyle = .none
        accessoryType = .none
    }
    
    convenience init(with type: BDWeekType, selected: Bool) {
        self.init()
        self.type = type
        self.selected = selected
        
        setSelectionHandler { [weak self] (item) in
            guard let strong = self else { return }
            strong.setIsOn(!strong.selected)
            strong.reload()
        }
    }

    // MARK: - private field
    typealias ValueChangedClosure = (Bool) -> Void

    private var didChangedClosure: ValueChangedClosure? = nil

}
