//
//  ScheduleItemDatasource.swift
//  CTFit
//
//  Created by Mac on 2020/7/15.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation

final class ScheduleItemDatasource {
    
    let scheduleItem: BDScheduleItem
        
    lazy var datePickerItem: DatePickerItem = DatePickerItem(with: .datetime, andDate: scheduleItem.date)
        
    lazy var vibrateItem: VibrateItem = {
        return VibrateItem(with: scheduleItem.vibrate.copy())
    } ()

    lazy var fieldItem: FieldItem = FieldItem(with: .label, content: scheduleItem.label, maxLenght: 30)

    init(with item: BDScheduleItem = BDScheduleItem()) {
        scheduleItem = item

        datePickerItem.setDateDidChangedClosure { [weak self] in
            guard let strong = self else { return }
            strong.scheduleItem.date = strong.datePickerItem.date
        }
        
        vibrateItem.setValueChanged { [weak self] (vibrate) in
            guard let strong = self else { return }
            strong.scheduleItem.vibrate = vibrate
        }
        
        fieldItem.setDidChangedClosure { [weak self] in
            guard let strong = self else { return }
            strong.scheduleItem.label = strong.fieldItem.content ?? ""
        }
    }
}


