//
//  VibrateDatasource.swift
//  CTFit
//
//  Created by Mac on 2020/7/16.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation

final class VibrateDatasource {
    var vibrate: BDVibrate
    lazy var bellItem: VibrateSelectItem = VibrateSelectItem(with: .bell, vibrate)
    lazy var numberItem: VibrateSelectItem = VibrateSelectItem(with: .bellCount, vibrate)
    
    init(with vibrate: BDVibrate ) {
        self.vibrate = vibrate
        bellItem.setValueChanged { [weak self] (vibrate) in
            guard let strong = self else { return }
            strong.vibrate.type = vibrate.type
        }
        numberItem.setValueChanged { [weak self] (vibrate) in
            guard let strong = self else { return }
            strong.vibrate.count = vibrate.count
        }
    }
}

