//
//  VibrateViewController.swift
//  CTFit
//
//  Created by Mac on 2020/7/15.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation
import TableViewManager

class VibrateViewController: BaseViewController, CustomView {
    
    typealias ViewClass = BaseTableView
        
    // MARK: - override
    
    override private init() {
        super.init()
        navigationItem.title = SRString.Vibrate.vibrate.locastr
    }
    
    convenience init(with vibrate: BDVibrate ) {
        self.init()
        datasource = VibrateDatasource(with: vibrate)
    }
    
    override func loadView() {
        super.loadView()
        view = ViewClass()
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        setupTableView()
    }
    
    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated)
        onDidChanged(model: datasource.vibrate)
    }

    override func initNavigationBar() {
        super.initNavigationBar()
    }
    
    // MARK: - tableViewManger
    
    private func setupTableView() {
        tableViewManger.reload()
    }
    
    private lazy var datasource: VibrateDatasource = VibrateDatasource(with: BDVibrate())
    
    private lazy var tableViewManger: ZJTableViewManager = {
        let manager = ZJTableViewManager(tableView: customView.tableView)
        manager.register(VibrateSelectCell.self, VibrateSelectItem.self)
        manager.register(PickerCell.self, PickerItem.self)
        manager.add(section: typeSection)
        manager.add(section: countSection)
        return manager
    } ()
    
    private lazy var typeSection: ZJTableViewSection = {
        let section = BaseTableViewSection()
        section.headerHeight = Constraints.normal; section.footerHeight = 0.01;
        section.add(item: datasource.bellItem)
        datasource.bellItem.addSubPickerItem(to: section)
        return section
    } ()
    
    private lazy var countSection: ZJTableViewSection = {
        let section = BaseTableViewSection(customHeader: SRString.Vibrate.vibrate_number.locastr, customFooter: nil)
        section.footerHeight = 0.01;
        section.add(item: datasource.numberItem)
        datasource.numberItem.addSubPickerItem(to: section)
        return section
    } ()
}
