//
//  DatePickerCell.swift
//  CTFit
//
//  Created by Mac on 2020/7/15.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit
import TableViewManager;

final class DatePickerCell: BaseTableViewCell, ZJCellProtocol {

    // MARK: - ZJCellProtocol
    
    var item: DatePickerItem!
    
    typealias ZJCelltemClass = DatePickerItem
    
    override func cellWillAppear() {
        super.cellWillAppear()
        if item.type == .time {
            datePicker.datePickerMode = .time
        } else if item.type == .datetime {
            datePicker.datePickerMode = .dateAndTime
        }
        datePicker.date = item.date
    }
    
    // MARK: - Initialize

    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: .default, reuseIdentifier: reuseIdentifier)
        addSubviews()
        setupConstraints()
    }
    
    // MARK: - Customer Views
    
    private func addSubviews() {
        [datePicker].forEach { view in
            view.translatesAutoresizingMaskIntoConstraints = false
            addSubview(view)
        }
    }

    private func setupConstraints() {
        datePicker.snp.makeConstraints { (make) in
            make.edges.equalToSuperview().inset(UIEdgeInsets(top: 0, left: 0, bottom: 0, right: 0))
        }
    }
    
    lazy var datePicker: UIDatePicker = {
        let picker = UIDatePicker()
        picker.datePickerMode = .time
        if #available(iOS 13.4, *) { picker.preferredDatePickerStyle = .wheels } 
        picker.setValue(Colors.Base.foreground, forKey: "textColor")
        if UIDevice.idiom != .pad {
            UILog.v("locale: \(CalendarUtils.locale.identifier)")
            picker.locale = CalendarUtils.locale
        }
        picker.addTarget(self, action: #selector(dateDidChanged), for: .valueChanged)
        return picker
    } ()
    
    @objc private func dateDidChanged() {
        item.date = datePicker.date
        item.onDateDidChanged()
    }

}
