//
//  DatePickerItem.swift
//  CTFit
//
//  Created by Mac on 2020/7/15.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation
import TableViewManager

enum DatePickerType {
    case time, datetime
}

final class DatePickerItem: BaseTableViewItem {
    
    var type: DatePickerType = .time

    var date: Date = Date()
    
    func onDateDidChanged() {
        guard let closure = dateDidChangedClosure else { return }
        closure()
    }
    
    func setDateDidChangedClosure(_ closure:@escaping DidChangedClosure) {
        dateDidChangedClosure = closure
    }
    
    // MARK: - Initialize
    
    private override init() {
        super.init()
        cellHeight = 216
        selectionStyle = .none
        accessoryType = .none
    }
    
    convenience init(with datePickerType: DatePickerType = .time, andDate: Date) {
        self.init()
        self.type = datePickerType
        self.date = andDate
    }
    
    // MARK: Private Field
    typealias DidChangedClosure = ()->Void
    
    private var dateDidChangedClosure: DidChangedClosure?
}

