//
//  RepeatCell.swift
//  CTFit
//
//  Created by Mac on 2020/7/15.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit
import TableViewManager

final class RepeatCell: BaseTableViewCell, ZJCellProtocol {

    // MARK: - ZJCellProtocol
    
    var item: RepeatItem!
    
    typealias ZJCelltemClass = RepeatItem
    
    override func cellWillAppear() {
        super.cellWillAppear()
        self.textLabel?.text = item.text
        self.detailTextLabel?.text = item.detailText
    }
    
    // MARK: - Initialize

    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: .value1, reuseIdentifier: reuseIdentifier)
        accessoryView = arrowView
    }
    
}

