//
//  RepeatItem.swift
//  CTFit
//
//  Created by Mac on 2020/7/15.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation
import TableViewManager

final class RepeatItem: BaseTableViewItem {
    
    var repeats: [BDWeekType] = []
    
    func setDidChangedClosure(_ closure:@escaping DidChangedClosure) {
        didChangedClosure = closure
    }
    
    // MARK: - Cell source
    
    var text: String { SRString.Vibrate.repeat.locastr }
    
    var detailText: String {
        let maskValue = BDWeekType.value(repeats)
        if maskValue == BDWeekType.none {
            return SRString.Clock.repeat_none.locastr
        } else if maskValue == BDWeekType.workday {
            return SRString.Clock.repeat_workday.locastr
        } else if maskValue == BDWeekType.everyday {
            return SRString.Clock.repeat_everyday.locastr
        } else {
            var text = ""
            BDWeekType.collection.forEach { (type) in
                if text.count != 0 { text.append(", ") }
                text.append(CalendarUtils.kShortWeekSymbols[type.index])
            }
            return text
        }
    }

    
    // MARK: - Initialize
    
    private override init() {
        super.init()
        accessoryType = .disclosureIndicator
    }
    
    convenience init(with repeatArray: [BDWeekType]) {
        self.init()
        self.repeats = repeatArray
        setSelectionHandler { [weak self] (item) in
            guard let strong = self else { return }
            strong.toRepeatPage()
        }
    }
    
    // MARK: Private Field
    
    typealias DidChangedClosure = ()->Void
    
    private var didChangedClosure: DidChangedClosure?
    
    private func onDidChanged() {
        guard let closure = didChangedClosure else { return }
        closure()
    }
}

extension RepeatItem {
    private func toRepeatPage() {
        let vc = RepeatViewController(with: repeats)
        Helper.currentVc?.navigationController?.pushViewController(vc, animated: true)
        vc.onDidChangedClosure { [weak self] obj in
            guard let strong = self, let newRepeats = obj as? [BDWeekType] else { return }
            strong.repeats = newRepeats
            strong.reload()
            strong.onDidChanged()
        }

    }
}
