//
//  VibrateCell.swift
//  CTFit
//
//  Created by Mac on 2020/7/16.
//  Copyright © 2020 shirajo. All rights reserved.
//


import UIKit
import TableViewManager

final class VibrateCell: BaseTableViewCell, ZJCellProtocol {

    // MARK: - ZJCellProtocol
    
    var item: VibrateItem!
    
    typealias ZJCelltemClass = VibrateItem
    
    override func cellWillAppear() {
        super.cellWillAppear()
        self.textLabel?.text = item.text
        self.detailTextLabel?.text = item.detailText
    }
    
    // MARK: - Initialize
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: .value1, reuseIdentifier: reuseIdentifier)
        accessoryView = arrowView
    }
}
