//
//  VibrateItem.swift
//  CTFit
//
//  Created by Mac on 2020/7/16.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation
import TableViewManager

final class VibrateItem: BaseTableViewItem {
    func setValueChanged(_ closure:@escaping ValueChangedClosure) {
        valueChangedClosure = closure
    }
    
    // MARK: - Cell source
    var text: String { SRString.Vibrate.vibrate.locastr }
    var detailText: String { vibrate.type.text }
    
    // MARK: - Initialize
    private override init() {
        super.init()
        accessoryType = .disclosureIndicator
    }
    convenience init(with vibrate: BDVibrate) {
        self.init()
        self.vibrate = vibrate
        onHander()
    }
    
    // MARK: Private
    private var vibrate: BDVibrate = BDVibrate()
    typealias ValueChangedClosure = (_ vibrate: BDVibrate) -> Void
    private var valueChangedClosure: ValueChangedClosure?
    private func onDidChanged() { if let closure = valueChangedClosure { closure(vibrate) } }
}

extension VibrateItem {
    private func onHander() {
        setSelectionHandler { [weak self] (item) in
            guard let strong = self else { return }
            strong.toVibrateController()
        }
    }
    
    private func toVibrateController() {
        let vc = VibrateViewController(with: vibrate)
        Helper.currentVc?.navigationController?.pushViewController(vc, animated: true)
        vc.onDidChangedClosure { [weak self] obj in
            guard let strong = self, let newVibrate = obj as? BDVibrate else { return }
            strong.vibrate = newVibrate
            strong.reload()
            strong.onDidChanged()
        }
    }
}
