//
//  AlarmAddItem.swift
//  CTFit
//
//  Created by Mac on 2020/7/13.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation
import TableViewManager

enum AlarmAddType {
    case clock, schedule
    
    var text: String {
        switch self {
        case .clock: return SRString.Clock.clock_reminder_add.locastr
        case .schedule: return SRString.Clock.schedules_reminder_add.locastr
        }
    }
    
}

final class AlarmAddItem: BaseTableViewItem {
    
    var type: AlarmAddType = .clock

    // MARK: - cell sources
    var text: String { type.text }
    
    // MARK: - Initialize
    private override init() {
        super.init()
        accessoryType = .disclosureIndicator
    }
    convenience init(with remenderType: AlarmAddType) {
        self.init()
        self.type = remenderType
    }
}


