//
//  ClockItem.swift
//  CTFit
//
//  Created by Mac on 2020/6/29.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation
import TableViewManager

final class ClockItem: BaseTableViewItem {
    
    typealias ValueChangedClosure = (Bool) -> Void
    
    var clockItem: BDClockItem = BDClockItem()
        
    func oneFeature(_ enable: Bool) {
        clockItem.enable = enable
    }
    
    // MARK: - Cell source
    var text: String { clockItem.time }
    var name: String { clockItem.label }
    var feature: Bool { clockItem.enable }

    // MARK: - Initialize
    private override init() {
        super.init()
        cellHeight = 65
        editingStyle = .delete
        accessoryType = .none
    }
    
    convenience init(with item: BDClockItem) {
        self.init()
        clockItem = item
        setSelectionHandler { [weak self] (item) in
            guard let strong = self else { return }
            strong.onSelectedHandler()
        }
    }
}
extension ClockItem {
    private func onSelectedHandler() {
        let vc = ClockItemViewController(with: clockItem)
        Helper.currentVc?.navigationController?.pushViewController(vc, animated: true)
        vc.onDidChangedClosure { [weak self] obj in
            guard let strong = self else { return }
            strong.reload()
        }
    }
}
