//
//  ScheduleCell.swift
//  CTFit
//
//  Created by Mac on 2020/7/13.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit
import Foundation
import SnapKit
import RxSwift
import TableViewManager;


final class ScheduleCell: BaseTableViewCell, ZJCellProtocol {

    // MARK: - ZJCellProtocol
    var item: ScheduleItem!
    typealias ZJCelltemClass = ScheduleItem
    override func cellWillAppear() {
        self.iconView.image = ImageRepo.Settings.ic_clock.reSizeImage(CGSize(width: 29, height: 29))
        self.textLabel?.text = item.text
        self.nameLabel.text = item.name
        self.switchControl.setOn(item.feature, animated: false)
        if item.name.count>0 {
            self.textLabel?.snp.updateConstraints { (make) in
                make.centerY.equalToSuperview().offset(-9)
            }
        } else {
            self.textLabel?.snp.updateConstraints { (make) in
                make.centerY.equalToSuperview()
            }
        }
    }
    
    // MARK: - Initialize

    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: .default, reuseIdentifier: reuseIdentifier)
        setConstraints()
    }

    private func setConstraints() {
        [iconView, nameLabel, switchControl].forEach { view in
            view.translatesAutoresizingMaskIntoConstraints = false
            addSubview(view)
        }
        
        iconView.snp.makeConstraints({ (make) in
            make.leading.equalTo(self.snp.leadingMargin)
            make.centerY.equalToSuperview()
        })
        
        self.textLabel?.snp.makeConstraints { (make) in
            make.centerY.equalToSuperview()
            make.left.equalTo(iconView.snp.right).offset(Constraints.normal)
            make.height.equalTo(20)
        }
        
        nameLabel.snp.makeConstraints { (make) in
            make.top.equalTo(textLabel!.snp.bottom)
            make.left.equalTo(textLabel!.snp.left)
        }
        
        switchControl.snp.makeConstraints { (make) in
            make.centerY.equalToSuperview()
            make.trailing.equalTo(self.snp.trailingMargin)
        }
    }
    
    // MARK: - View customer
    
    private let disposeBag = DisposeBag()
    
    private lazy var iconView: UIImageView = {
        let view = UIImageView()
        return view
    }()
    
    private lazy var nameLabel: UILabel = {
        let label = UILabel(style: Stylesheet.Label.description)
        return label
    }()
    
    private lazy var switchControl: UISwitch = {
        let _switch = UISwitch()
        _switch.rx.isOn.asObservable()
        .subscribe(onNext: {[unowned self] (isOn) in
            self.item?.onFeature(isOn)
        }).disposed(by: disposeBag)
        return _switch
    }()
}

