//
//  ScheduleItem.swift
//  CTFit
//
//  Created by Mac on 2020/7/13.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation
import TableViewManager
import Repeater


final class ScheduleItem: BaseTableViewItem {
    
    typealias ValueChangedClosure = (Bool) -> Void
    
    var scheduleItem: BDScheduleItem = BDScheduleItem()
        
    func onFeature(_ feature: Bool) {
        scheduleItem.enable = feature
        guard feature else { return }
        guard !self.feature else { return }
        let offSeconds = Date().timeIntervalSince1970 - scheduleItem.time
        let offDays = offSeconds/TimeInterval(CalendarUtils.kSecondsOneDay)
        scheduleItem.time += TimeInterval(CalendarUtils.kSecondsOneDay) * (offDays+1)
        reload()
    }
    
    // MARK: - Cell source
    var text: String { scheduleItem.datetime }
       
    var name: String { scheduleItem.label }

    var feature: Bool { scheduleItem.enable && scheduleItem.time > Date().timeIntervalSince1970 }
    
    // MARK: - Initialize
    private override init() {
        super.init()
        cellHeight = 65
        editingStyle = .delete
        accessoryType = .none
    }
    
    convenience init(with item: BDScheduleItem) {
        self.init()
        scheduleItem = item
        setSelectionHandler { [weak self] (item) in
            guard let strong = self else { return }
            strong.toEditScheduleItem()
        }
        updateTimer.start()
    }
    
    private lazy var updateTimer: Repeater = {
        let repeater = Repeater.every(.seconds(5)) { repeater in
            DispatchQueue.main.async { [weak self] () in
                guard let strong = self else { return }
                guard !strong.feature else { return }
                strong.reload()
            }
        }
        repeater.pause()
        return repeater;
    }()
}

extension ScheduleItem {
    private func toEditScheduleItem() {
        scheduleItem.enable = true
        let vc = ScheduleItemViewController(with: scheduleItem)
        Helper.currentVc?.navigationController?.pushViewController(vc, animated: true)
        vc.onDidChangedClosure { [weak self] obj in
            guard let strong = self else { return }
            strong.reload()
        }
    }
}
