//
//  HomeCircleContrller.swift
//  CTFit
//
//  Created by Mac on 2020/9/2.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import UIKit

class HomeCircleContrller: BaseViewController, CustomView {
   
    typealias ViewClass = HomeCircleView
    
    override init() {
        super.init()
        navigationItem.title = AppUtils.shared.name
    }
    
    override func loadView() {
        super.loadView()
        view = ViewClass()
    }

    override func initNavigationBar() {
        rightBarIsConnectState = true
        super.initNavigationBar()
        navigationItem.leftBarButtonItem = self.shareBarItem()
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupSubviews()
        GuidView.loading()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        customView.viewWillAppear()
    }
    
    override func viewDidAppear(_ animated: Bool) {
        super.viewDidAppear(animated)
        customView.viewDidAppear()
    }
    
    // MARK: - View customer
    private func setupSubviews() {
        customView.onDidSelectedMenu {[weak self] (type) in
            guard let strong = self else { return }
            switch type {
            case .settings: strong.push(SettingsViewController())
            case .sport: strong.push(SportViewController())
            case .step: strong.push(RecordStepViewController())
            case .heartRate: strong.push(HeartRateDetailViewController())
            case .sleep: strong.push(RecordSleepViewController())
            case .camera: strong.presentCamera()
            default : break
            }
        }
        
        customView.onDidSelectedAttr { [weak self] (type) in
            guard let strong = self else { return }
            switch type {
            case .heart: strong.push(HeartRateDetailViewController())
            default: strong.push(RecordStepViewController())
            }
        }
    }
    
    private func push(_ vc: UIViewController) {
        guard let _ = Helper.currentVc as? HomeCircleContrller else { return }
        navigationController?.pushViewController(vc, animated: true)
    }
    
    private func presentCamera() {
        let cameraNavivc = BaseNavigationController(rootViewController: SRCameraViewController(type: .device))
        cameraNavivc.modalPresentationStyle = .fullScreen
        guard let _ = Helper.currentVc as? HomeCircleContrller else { return }
        present(cameraNavivc, animated: true, completion: nil)
    }
}

extension HomeCircleContrller {
    override func screenSnapshot(save: Bool = false) -> UIImage? {
        return customView.bgImage
    }
    
    override func onConnected() {
        super.onConnected()
        customView.onUpdate()
    }
}
