//
//  HomeListController.swift
//  CTFit
//
//  Created by Mac on 2020/11/23.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import UIKit
import RxSwift
import TableViewManager
import Toast


class HomeListController: BaseViewController, CustomView {

    typealias ViewClass = BaseTableView
    
    // MARK: - override
    
    override init() {
        super.init()
        navigationItem.title = AppUtils.shared.name
    }

    override func loadView() {
        super.loadView()
        view = ViewClass()
    }
    
    override func initNavigationBar() {
        rightBarIsConnectState = true
        super.initNavigationBar()
        navigationItem.leftBarButtonItem = self.shareBarItem()
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        setupTableView()
        GuidView.loading()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        datasource.showToady()
    }
    
    override func viewDidDisappear(_ animated: Bool) {
        super.viewDidDisappear(animated)
    }
    
    // MARK: - View customer
    private func setupTableView() {
        tableViewManger.reload()
    }
    
    // MARK: - TableViewManager
    
    fileprivate lazy var datasource: HomeListDatasource = HomeListDatasource();
    
    fileprivate lazy var datebarSection: BaseTableViewSection = {
        let section = BaseTableViewSection()
        section.headerHeight = 0.01
        section.footerHeight = 0.01
        section.add(item: datasource.dateBarItem)
        return section
    } ()

    
    fileprivate lazy var listSection: BaseTableViewSection = {
        let section = BaseTableViewSection()
        section.headerHeight = 0.01
        section.footerHeight = 0.01
        datasource.listItems.forEach { (e) in
            section.add(item: e)
        }
        return section
    } ()
    
    fileprivate lazy var tableViewManger: ZJTableViewManager = {
        let manager = ZJTableViewManager(tableView: customView.tableView)
        manager.register(DateBarListCell.self, DateBarItem.self)
        manager.register(HomeCircleCell.self, HomeCircleItem.self)
        manager.register(HomeListCell.self, HomeListItem.self)
        manager.add(section: datebarSection)
        manager.add(section: listSection)
        return manager;
    } ()
}
