//
//  HomeTabBarController.swift
//  CTFit
//
//  Created by Mac on 2020/11/30.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import UIKit

class HomeTabBarController: UITabBarController, UITabBarControllerDelegate {
    
    var sportVc: SportViewController!;
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view.
        loadViewControllers()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
    }
    
    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated);
    }
    
    func loadViewControllers(){
        let homeNav = BaseNavigationController.init(rootViewController: HomeListController())
        homeNav.tabBarItem.title = SRString.Tabbar.home.locastr
        homeNav.tabBarItem.image = ImageRepo.HomeList.Tabbar.step1
        homeNav.tabBarItem.selectedImage = ImageRepo.HomeList.Tabbar.step2
        
        sportVc = SportViewController()
        let gpxNav = BaseNavigationController.init(rootViewController: sportVc)
        gpxNav.tabBarItem.title = SRString.Tabbar.agps.locastr
        gpxNav.tabBarItem.image = ImageRepo.HomeList.Tabbar.agps1
        gpxNav.tabBarItem.selectedImage = ImageRepo.HomeList.Tabbar.agps2

        let settingNav = BaseNavigationController.init(rootViewController: SettingsViewController())
        settingNav.tabBarItem.title = SRString.Tabbar.setting.locastr
        settingNav.tabBarItem.image = ImageRepo.HomeList.Tabbar.setting1
        settingNav.tabBarItem.selectedImage = ImageRepo.HomeList.Tabbar.setting2

        self.tabBar.tintColor = Colors.blue;
        self.tabBar.barTintColor = Colors.Base.background;
        self.tabBar.isTranslucent = false;
        
        self.delegate = self;
        self.viewControllers = [homeNav, gpxNav, settingNav]
    }

    func tabBarController(_ tabBarController: UITabBarController, shouldSelect viewController: UIViewController) -> Bool {
        if selectedIndex == 1, sportVc.exercising {
            AlertManager.show(title: SRString.Base.alert.locastr, message: SRString.Sport.longpress_sport_end.locastr) { (_) in }
            return false;
        }
        return true;
    }
    
    func tabBarController(_ tabBarController: UITabBarController, didSelect viewController: UIViewController) {
        if selectedIndex == 1 {
            LocationHelper.showNoLocationPermissionAlert()
        }
    }
}
