//
//  HomeCircleItem.swift
//  CTFit
//
//  Created by Mac on 2020/11/23.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import UIKit
import TableViewManager;

final class HomeCircleItem: BaseTableViewItem {
    
    // MARK: - Initialize
    private override init() {
        super.init()
        selectionStyle = .default
        accessoryView = .none
        cellHeight = 240
    }
    convenience init(with total: BDTotal = BDTotal()) {
        self.init()
        self.total = total
        onHandler()
    }
    
    func update(_ total: BDTotal) {
        self.total = total
        reload()
    }
    
    // MARK: - Cell source
    var total: BDTotal!
}


extension HomeCircleItem {
    private func onHandler() {
        setSelectionHandler { [weak self] (item) in
            guard let strong = self else { return }
            strong.didSelectedHandler()
        }
    }
    
    private func didSelectedHandler() {
        push(RecordStepViewController())
    }
    
    private func push(_ vc: BaseViewController) {
        guard let currentVc = Helper.currentVc as? HomeListController else { return }
        currentVc.navigationController?.pushViewController(vc, animated: true)
    }
    
}
