//
//  HomeListCell.swift
//  CTFit
//
//  Created by Mac on 2020/11/26.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import UIKit
import TableViewManager;

final class HomeListCell: BaseTableViewCell, ZJCellProtocol {

    // MARK: - ZJCellProtocol
    var item: HomeListItem!
    typealias ZJCelltemClass = HomeListItem
    override func cellWillAppear() {
        iconView.image = item.icon
        valueLabel.attributedText = item.text
    }
    
    // MARK: - Initialize
    override func prepareForReuse() {
        super.prepareForReuse()
       
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: .default, reuseIdentifier: reuseIdentifier)
        setConstraints()
    }
    
   
    // MARK: - View customer
    private func setConstraints() {
        [iconView, valueLabel].forEach { view in
            view.translatesAutoresizingMaskIntoConstraints = false
            addSubview(view)
        }
        
        iconView.snp.makeConstraints { (make) in
            make.centerY.equalToSuperview()
            make.leading.equalTo(self.snp.leadingMargin).offset(Constraints.large)
        }
        
        valueLabel.snp.makeConstraints { (make) in
            make.centerY.equalToSuperview()
            make.leading.equalTo(iconView.snp.trailing).offset(Constraints.large)
        }
    }
        
    private lazy var iconView: UIImageView = {
        let view = UIImageView()
        return view
    } ()
    
    private let valueLabel: UILabel = {
        let label = UILabel(style: Stylesheet.Label.text)
        label.font = .lightCustomFont(ofSize: 35)
        return label
    } ()
}
