//
//  PrivacyViewController.swift
//  CTFit
//
//  Created by Mac on 2020/9/18.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import UIKit

class PrivacyViewController: BaseViewController, CustomView {
    
    typealias ViewClass = PrivacyView
    
    override init() {
        super.init()
        navigationItem.title = "Privacy"
        modalPresentationStyle = .fullScreen
    }

    override func loadView() {
        super.loadView()
        view = ViewClass()
    }

    override func initNavigationBar() {
        super.initNavigationBar()
        navigationItem.rightBarButtonItem = customView.submitBarItem
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        customView.loadPrivacy()
    }
    
    override func viewDidAppear(_ animated: Bool) {
        super.viewDidAppear(animated)
    }
}


