//
//  DetectDatasource.swift
//  CTFit
//
//  Created by Mac on 2020/10/28.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import Foundation
import RxSwift

final class DetectDatasource {

    lazy var heartItem: DetectItem =  DetectItem(with: .bpm)

    lazy var pressureItem: DetectItem =  DetectItem(with: .bp)

    init(date: Date = Date()) {
        queary()
        observers()
        BandCommand.readDetectRecords()
        heartItem.model.onDetectState { [weak self] (detcting) in
            guard let strong = self else { return }
            strong.heartItem.reload()
            strong.pressureItem.model.detectEnable = !detcting
            strong.pressureItem.model.reloadChart = false
            strong.pressureItem.reload()
        }
        pressureItem.model.onDetectState { [weak self] (detcting) in
            guard let strong = self else { return }
            strong.pressureItem.reload()
            strong.heartItem.model.detectEnable = !detcting
            strong.heartItem.model.reloadChart = false
            strong.heartItem.reload()
        }
    }
    
    private func queary() {
        BandData.queryDetect { [weak self] () in
            guard let strong = self else { return }
            strong.reloadChart(for: .bpm)
            strong.reloadChart(for: .bp)
        }
    }
    
    private func reloaEnd(for type: BDDetectType) {
        if type == .bpm { heartItem.model.onDetected() }
        if type == .bp { pressureItem.model.onDetected() }
    }
    
    private func reloadChart(for type: BDDetectType) {
        if type == .bpm, heartItem.model.detectValues != BDDetect.heartItems{
            heartItem.model.detectValues = BDDetect.heartItems
            heartItem.reload()
        }
        if type == .bp, pressureItem.model.detectValues != BDDetect.pressureItems {
            pressureItem.model.detectValues = BDDetect.pressureItems
            pressureItem.reload()
        }
    }
    
    private func observers() {
        BandData.updatedOutput.observeOn(MainScheduler.instance).subscribe(onNext: { [weak self] (type) in
            guard let strong = self else { return }
            switch type {
            case .detectInfo(let items):
                guard items.count > 0 else { return }
                items.forEach { (item) in
                    if item.detected { strong.reloaEnd(for: item.type) }
                    else { BDDetect.reloadItems();  strong.reloadChart(for: item.type) }
                }
            default : break
            }
        }).disposed(by: disposeBag)
    }
    
    // MARK: - Private field
    private lazy var disposeBag = DisposeBag()

}
