//
//  DetectDetailViewController.swift
//  CTFit
//
//  Created by Mac on 2020/10/28.
//  Copyright © 2020 jpaxh. All rights reserved.
//


import UIKit
import RxSwift
import TableViewManager

class DetectDetailViewController: BaseViewController, CustomView {
    
    typealias ViewClass = BaseTableView
    
    private override init() {
        super.init()
        navigationItem.title = SRString.Detect.manual_detect.locastr
    }
    
    convenience init(date: Date = Date()) {
        self.init()
        datasource = DetectDatasource()
    }
        
    override func loadView() {
        super.loadView()
        view = ViewClass()
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        setupTableView()
    }
   
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
    }
    
    override func viewDidAppear(_ animated: Bool) {
        super.viewDidLoad()
    }
    
    override func initNavigationBar() {
        super.initNavigationBar()
        navigationItem.rightBarButtonItem = self.shareBarItem()
    }
    
    // MARK: - tableViewManger

    fileprivate var datasource: DetectDatasource!
    
    fileprivate lazy var tableViewManger: ZJTableViewManager = {
        let manager = ZJTableViewManager(tableView: customView.tableView)
        manager.register(DetectCell.self, DetectItem.self)
        manager.add(section: section)
        return manager
    } ()
    
    
    
    fileprivate lazy var section: ZJTableViewSection = {
        let section = BaseTableViewSection()
        section.headerHeight = 0.1
        section.add(item: datasource.heartItem)
        section.add(item: datasource.pressureItem)
        return section;
    } ()


    private func setupTableView() {
        customView.tableView.separatorInset = UIEdgeInsets(top: 0, left: 0, bottom: 0, right: 0)
        tableViewManger.reload()
    }
    
}
