//
//  HeartDayDatasource.swift
//  CTFit
//
//  Created by Mac on 2020/6/6.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation
import RxSwift

final class HeartDayDatasource {
    
    let dateBarItem: DateBarItem = DateBarItem(date: Date())
    
    let heartDaytItem: HeartDayItem = HeartDayItem()

    init(date: Date = Date()) {
        dateBarItem.date = date
        queary()
        observers()
        dateBarItem.onValueChanged { [weak self] (dateBar) in
            guard let strong = self else { return }
            strong.queary()
        }
        BandCommand.readRecordDetailToday(with: .heart)
    }
    
    var dateStr: String { dateFormatter.string(from: dateBarItem.date) }
    
    lazy var dateFormatter :DateFormatter = {
        let formatter = DateFormatter();
        formatter.dateFormat = "yyyy-MM-dd";
        return formatter;
    }()
    
    private func queary() {
        BandData.queryHeart(with: dateBarItem.date) { [weak self] heart in
            guard let strong = self else { return }
            strong.heartDaytItem.heart = heart ?? BDHeart()
            strong.heartDaytItem.reload()
        }
    }
    
    private func observers() {
        BandData.updatedOutput.observeOn(MainScheduler.instance).subscribe(onNext: { [weak self] (type) in
            guard let strong = self else { return }
            switch type {
            case .record(let type, let dateStr):
                guard dateStr == strong.dateStr else { return }
                switch type {
                case .heart: strong.queary()
                default: break
                }
            default : break
            }
        }).disposed(by: disposeBag)
    }
    
    // MARK: - Private field
    private lazy var disposeBag = DisposeBag()
  
}


