//
//  HeartRateDetailViewController.swift
//  CTFit
//
//  Created by Mac on 2020/5/29.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit
import RxSwift
import TableViewManager

class HeartRateDetailViewController: BaseViewController, CustomView {
    
    typealias ViewClass = BaseTableView
    
     private override init() {
        super.init()
        hidesBottomBarWhenPushed = true
        navigationItem.title = SRString.Heart.heart_rate.locastr
    }
    
    convenience init(date: Date = Date()) {
        self.init()
        datasource = HeartDayDatasource(date: date)
    }
        
    override func loadView() {
        super.loadView()
        view = ViewClass()
        customView.reloadForRecordHeart()
        customView.groundImage.image =  ImageRepo.Heart.bg
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupTableView()
    }
   
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
    }
    
    override func initNavigationBar() {
        super.initNavigationBar()
        navigationItem.rightBarButtonItem = self.shareBarItem()
    }

    // MARK: - tableViewManger
    
    fileprivate func setupTableView() {
        customView.tableView.separatorStyle = .none
        tableViewManger.reload();
    }
    
    fileprivate var datasource: HeartDayDatasource!
    
    fileprivate lazy var tableViewManger: ZJTableViewManager = {
        let manager = ZJTableViewManager(tableView: customView.tableView)
        manager.register(DateBarCell.self, DateBarItem.self)
        manager.register(HeartDayCell.self, HeartDayItem.self)
        manager.add(section: dateBarSection)
        manager.add(section: heartDaySection)
        return manager
    } ()
    
    fileprivate lazy var dateBarSection: ZJTableViewSection = {
        let section = BaseTableViewSection()
        section.headerHeight = 0.01
        section.add(item: datasource.dateBarItem)
        return section;
    } ()
    
    fileprivate lazy var heartDaySection: ZJTableViewSection = {
        let section = BaseTableViewSection()
        section.headerHeight = 0.01
        section.add(item: datasource.heartDaytItem)
        return section;
    } ()
}

