//
//  HeartDayItem.swift
//  CTFit
//
//  Created by Mac on 2020/6/6.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation
import TableViewManager

final class HeartDayItem: BaseTableViewItem {
        
    var heart: BDHeart = BDHeart()
    
    override init() {
        super.init()
        selectionStyle = .none
        accessoryType = .none
        isAutoHeight = true
    }
}

extension HeartDayItem {
    func onDetect()  {
        push(DetectDetailViewController())
    }
    fileprivate func push(_ vc: BaseViewController) {
        Helper.currentVc?.navigationController?.pushViewController(vc, animated: true)
    }
}
